/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading;

import java.math.BigDecimal;

public class Trade {
    private final Type type;
    private final BigDecimal volume;
    private final BigDecimal price;
    private BigDecimal tradingPrice = null;
    private final long time;

    public Trade(Type type, BigDecimal price, BigDecimal volume, long time) {
        this.type = type;
        this.price = price;
        this.volume = volume;
        this.time = time;
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public long getTime() {
        return this.time;
    }

    public BigDecimal getTradingPrice() {
        if (this.tradingPrice == null) {
            this.tradingPrice = this.price.multiply(this.volume);
        }
        return this.tradingPrice;
    }

    public void setTradingPrice(BigDecimal tradingPrice) {
        this.tradingPrice = tradingPrice;
    }

    public static enum Type {
        BUY,
        SELL;

    }
}

