/**
 * 다이버 전스 divergence
 *
 * 주가는 상승하는데 보조지표는 하락하고 있거나, 주가는 하락하는데 보조지표는 상승하고 있는 현상을 나타냄
 * 
 * 다이버전스의 발생이유는 추세의 힘이 약해지는것
 * 
 * 1.일반 다이버전스
 * - 일반하락 다이버전스
 *  주가의 고점을 상승하고 있으나, 보조지표 고점은 하락하고 있는상태
 *  주가 고점이 상승하고 있으나, 보조지표 고점은 횡보하고 있는 상태도 하락 다이버전스임
 *  주가 고점이 횡보하고 있고, 보조지표 고점이 하락하고 있는 상태도 하락 다이버전스임.
 *  
 * - 일반상승 다이버전스
 *  주가의 저점이 하락하고 있고, 보조지표 저점이 상승하고 있는 상태
 *  주가의 저점이 하락하고 있으니, 보조지표 저점은 횡보하고 있는 상태도 상승 다이버전스임.
 *  주가의 저점이 횡보하고 있고, 보조지표 저점이 상승하고 있는 상태도 상승 다이버전스임
 *  상승추세로 전환 가능성 높음
 *  
 * 2. 히든 다이버전스
 *  - 히든 하락 다이버전스
 *   주가의 고점이 낮아지고 보조지표 고점이 상승하는 현상을 히든 하락 다이버전스라고 함
 *   하락추세로 전환 가능성 높음
 *    
 *  - 히든 상승 다이버전스
 *   주가의 저점이 높아지고, 보조지표 저점이 하락하는 현상을 히든 상승 다이버전스라고 함
 *   상승추세로 전환 가능성 높음
 *   
 * 3. 과장된 다이버전스
 *  - 과장된 하락 다이버전스 
 *  주가가 비슷한 높이의 고점을 형성하는 동안, 보조지표 고점이 하락하는 현상
 *  하락추세로 전환가능성이 높음
 *  
 *  - 과장된 상승 다이버전스
 *   주가가 비슷한 높이의 저점을 형성하는 동안,, 보조지표 저점이 상승하는 현상
 *   상승추세로 전환 가능성이 높음
 *  
 *
 * @author macle
 */
package io.runon.trading.technical.analysis.subindex.divergence;