/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.pattern.lower.shadow;

import io.runon.trading.PriceChangeType;
import io.runon.trading.TradingBigDecimal;
import io.runon.trading.TrendChangeType;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.pattern.CandlePatternDefault;
import io.runon.trading.technical.analysis.pattern.CandlePatternPoint;
import io.runon.trading.technical.analysis.pattern.lower.shadow.LowerShadowPattern;
import io.runon.trading.technical.analysis.trend.line.TrendLine;
import java.math.BigDecimal;

public class HammerPattern
extends CandlePatternDefault {
    @Override
    public PriceChangeType getPriceChangeType() {
        return PriceChangeType.RISE;
    }

    @Override
    public TrendChangeType getTrendChangeType() {
        return TrendChangeType.REVERSE;
    }

    @Override
    public CandlePatternPoint getPoint(TradeCandle[] candles, int index, BigDecimal shortGapRate) {
        TradeCandle tradeCandle = candles[index];
        if (tradeCandle.getOpen().compareTo(tradeCandle.getClose()) > 0) {
            return null;
        }
        if (tradeCandle.getChangeRate().multiply(TradingBigDecimal.DECIMAL_2).compareTo(shortGapRate) < 0) {
            return null;
        }
        TrendLine trendLine = new TrendLine(TrendLine.Type.DOWN);
        return LowerShadowPattern.makePoint(trendLine, candles, index, shortGapRate);
    }
}

