/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.candle.candles;

import io.runon.trading.Trade;
import io.runon.trading.TradeAdd;
import io.runon.trading.technical.analysis.candle.CandleStick;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.candle.candles.CandleChangeObserver;
import io.runon.trading.technical.analysis.candle.candles.FirstTradeAdd;
import io.runon.trading.technical.analysis.candle.candles.NextTradeAdd;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeCandles {
    private static final Logger logger = LoggerFactory.getLogger(TradeCandles.class);
    public static final int DEFAULT_COUNT = 1000;
    private static final CandleChangeObserver[] EMPTY_OBSERVER = new CandleChangeObserver[0];
    public static final TradeCandle[] EMPTY_CANDLES = new TradeCandle[0];
    private final long timeGap;
    private int count = 1000;
    TradeAdd tradeAdd;
    List<TradeCandle> candleList = new LinkedList<TradeCandle>();
    TradeCandle[] candles = EMPTY_CANDLES;
    TradeCandle lastCandle = null;
    BigDecimal shortGapRatio;
    BigDecimal steadyGapRatio;
    boolean isEmptyCandleContinue = false;
    boolean isEmptyCandleMake = false;
    private final Object observerLock = new Object();
    private CandleChangeObserver[] observers = EMPTY_OBSERVER;
    private final List<CandleChangeObserver> observerList = new LinkedList<CandleChangeObserver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeObserver(CandleChangeObserver candleChangeObserver) {
        Object object = this.observerLock;
        synchronized (object) {
            if (this.observerList.contains(candleChangeObserver)) {
                return;
            }
            this.observerList.add(candleChangeObserver);
            this.observers = this.observerList.toArray(new CandleChangeObserver[0]);
        }
    }

    public void setCandleType() {
        TradeCandle[] candles;
        if (this.steadyGapRatio == null || this.shortGapRatio == null) {
            logger.error("shortGapPercent, steadyGapPercent set: " + this.shortGapRatio + ", " + this.steadyGapRatio);
            return;
        }
        for (TradeCandle candle : candles = this.candles) {
            candle.setType(this.shortGapRatio, this.steadyGapRatio);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(CandleChangeObserver candleChangeObserver) {
        Object object = this.observerLock;
        synchronized (object) {
            if (!this.observerList.contains(candleChangeObserver)) {
                return;
            }
            this.observerList.remove(candleChangeObserver);
            this.observers = this.observerList.toArray(new CandleChangeObserver[0]);
        }
    }

    public TradeCandles(long timeGap) {
        if (timeGap < 86400000L && 86400000L % timeGap != 0L) {
            throw new RuntimeException("24 hour % timeGap 0: " + 86400000L % timeGap);
        }
        this.timeGap = timeGap;
        this.tradeAdd = new FirstTradeAdd(this);
    }

    public void setEmptyCandleContinue(boolean emptyCandleContinue) {
        this.isEmptyCandleContinue = emptyCandleContinue;
    }

    public TradeCandles(long timeGap, TradeCandle[] candles, int saveCount) {
        if (timeGap < 86400000L && 86400000L % timeGap != 0L) {
            throw new RuntimeException("24 hour % timeGap 0: " + 86400000L % timeGap);
        }
        this.timeGap = timeGap;
        this.count = saveCount;
        if (candles == null || candles.length == 0) {
            this.tradeAdd = new FirstTradeAdd(this);
            return;
        }
        this.lastCandle = candles[candles.length - 1];
        this.tradeAdd = new NextTradeAdd(this);
        if (candles.length <= saveCount) {
            this.candleList.addAll(Arrays.asList(candles));
            this.candles = candles;
        } else {
            for (int i = candles.length - saveCount; i < candles.length; ++i) {
                this.candleList.add(candles[i]);
            }
            this.candles = this.candleList.toArray(new TradeCandle[0]);
        }
    }

    public void addCandle(TradeCandle[] tradeCandles) {
        for (TradeCandle tradeCandle : tradeCandles) {
            this.addCandle(tradeCandle, false);
        }
        this.candles = this.candleList.toArray(new TradeCandle[0]);
    }

    public void addCandle(TradeCandle tradeCandle) {
        this.addCandle(tradeCandle, true);
    }

    public void addCandle(TradeCandle tradeCandle, boolean isNewCandles) {
        CandleChangeObserver[] observers;
        TradeCandle lastEndCandle = null;
        if (this.candles.length > 0) {
            lastEndCandle = this.candles[this.candles.length - 1];
            lastEndCandle.setEndTrade();
            if (this.shortGapRatio != null && this.steadyGapRatio != null && lastEndCandle.getType() == CandleStick.Type.UNDEFINED) {
                lastEndCandle.setType(lastEndCandle.getOpen().multiply(this.shortGapRatio), lastEndCandle.getOpen().multiply(this.steadyGapRatio));
            }
            if (tradeCandle.isEndTrade()) {
                if (this.shortGapRatio != null && this.steadyGapRatio != null && tradeCandle.getType() == CandleStick.Type.UNDEFINED) {
                    tradeCandle.setType(tradeCandle.getOpen().multiply(this.shortGapRatio), tradeCandle.getOpen().multiply(this.steadyGapRatio));
                }
                lastEndCandle = tradeCandle;
            }
        }
        this.candleList.add(tradeCandle);
        while (this.candleList.size() >= this.count) {
            this.candleList.remove(0);
        }
        if (isNewCandles) {
            this.candles = this.candleList.toArray(new TradeCandle[0]);
        }
        this.lastCandle = tradeCandle;
        for (CandleChangeObserver observer : observers = this.observers) {
            observer.changeCandle(lastEndCandle, tradeCandle);
        }
    }

    public void addTrade(Trade trade) {
        this.tradeAdd.addTrade(trade);
    }

    public long getTimeGap() {
        return this.timeGap;
    }

    public void setCount(int count) {
        this.count = count;
    }

    void addTradeNewCandle(Trade trade, long startTime, long endTime) {
        TradeCandle tradeCandle = new TradeCandle();
        tradeCandle.setOpenTime(startTime);
        tradeCandle.setCloseTime(endTime);
        tradeCandle.addTrade(trade);
        this.addCandle(tradeCandle);
    }

    public int getCount() {
        return this.count;
    }

    public int length() {
        return this.candles.length;
    }

    public TradeCandle[] getCandles() {
        return this.candles;
    }

    public void setShortGapRatio(BigDecimal shortGapRatio) {
        this.shortGapRatio = shortGapRatio;
    }

    public void setSteadyGapRatio(BigDecimal steadyGapRatio) {
        this.steadyGapRatio = steadyGapRatio;
    }

    public BigDecimal getShortGapRatio() {
        return this.shortGapRatio;
    }

    public BigDecimal getSteadyGapRatio() {
        return this.steadyGapRatio;
    }
}

