/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.candle;

import io.runon.trading.Trade;
import io.runon.trading.TradingBigDecimal;
import io.runon.trading.technical.analysis.candle.CandleStick;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeCandle
extends CandleStick {
    private static final Logger logger = LoggerFactory.getLogger(TradeCandle.class);
    private BigDecimal volume = BigDecimal.ZERO;
    private BigDecimal buyVolume = BigDecimal.ZERO;
    private BigDecimal sellVolume = BigDecimal.ZERO;
    private int tradeCount = 0;
    BigDecimal priceTotal = BigDecimal.ZERO;
    private List<Trade> tradeList = null;
    public static final BigDecimal MAX_STRENGTH = new BigDecimal(500);
    private BigDecimal strength = null;

    public BigDecimal getAverage() {
        return this.priceTotal.divide(this.volume, MathContext.DECIMAL128);
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public void addTrade(Trade trade) {
        if (this.tradeList == null) {
            this.tradeList = new ArrayList<Trade>();
            this.setOpen(trade.getPrice());
            this.setClose(trade.getPrice());
            this.high = trade.getPrice();
            this.low = trade.getPrice();
        } else {
            if (this.high.compareTo(trade.getPrice()) < 0) {
                this.high = trade.getPrice();
            } else if (this.low.compareTo(trade.getPrice()) > 0) {
                this.low = trade.getPrice();
            }
            this.setClose(trade.getPrice());
        }
        this.tradeList.add(trade);
        this.tradeCount = this.tradeList.size();
        if (trade.getType() == Trade.Type.BUY) {
            this.buyVolume = this.buyVolume.add(trade.getVolume());
        } else {
            this.sellVolume = this.sellVolume.add(trade.getVolume());
        }
        this.volume = this.volume.add(trade.getVolume());
        this.priceTotal = this.priceTotal.add(trade.getVolume().multiply(trade.getPrice()));
    }

    public int getTradeCount() {
        return this.tradeCount;
    }

    public void setCandleToTrade() {
        if (this.tradeList == null || this.tradeList.size() == 0) {
            logger.error("trade data not set");
            return;
        }
        this.priceTotal = BigDecimal.ZERO;
        this.tradeCount = this.tradeList.size();
        Trade firstTrade = this.tradeList.get(0);
        Trade endTrade = this.tradeList.get(this.tradeList.size() - 1);
        this.setOpen(firstTrade.getPrice());
        this.setClose(endTrade.getPrice());
        this.volume = BigDecimal.ZERO;
        BigDecimal high = firstTrade.getPrice();
        BigDecimal low = firstTrade.getPrice();
        for (Trade trade : this.tradeList) {
            this.volume = this.volume.add(trade.getVolume());
            this.priceTotal = this.priceTotal.add(trade.getVolume().multiply(trade.getPrice()));
            if (high.compareTo(trade.getPrice()) < 0) {
                high = trade.getPrice();
            }
            if (low.compareTo(trade.getPrice()) > 0) {
                low = trade.getPrice();
            }
            if (trade.getType() == Trade.Type.BUY) {
                this.buyVolume = this.buyVolume.add(trade.getVolume());
                continue;
            }
            this.sellVolume = this.sellVolume.add(trade.getVolume());
        }
        this.setHigh(high);
        this.setLow(low);
    }

    public void setStrength(BigDecimal strength) {
        this.strength = strength;
    }

    public BigDecimal strength() {
        if (this.isEndTrade && this.strength != null) {
            return this.strength;
        }
        if (this.sellVolume == null && this.buyVolume == null) {
            return BigDecimal.ONE;
        }
        if (this.sellVolume == null || this.sellVolume.compareTo(BigDecimal.ZERO) == 0) {
            return MAX_STRENGTH;
        }
        BigDecimal strength = this.buyVolume.divide(this.sellVolume, MathContext.DECIMAL128).multiply(TradingBigDecimal.DECIMAL_100);
        if (strength.compareTo(MAX_STRENGTH) > 0) {
            this.strength = MAX_STRENGTH;
            return MAX_STRENGTH;
        }
        this.strength = strength;
        return strength;
    }

    public void clearTrade() {
        if (this.tradeList == null) {
            return;
        }
        this.tradeList.clear();
        this.tradeList = null;
    }

    public void setTradeCount(int tradeCount) {
        this.tradeCount = tradeCount;
    }
}

