/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.candle;

import io.runon.trading.PriceChange;
import io.runon.trading.PriceChangeType;
import io.runon.trading.technical.analysis.candle.Candle;
import java.math.BigDecimal;
import java.math.MathContext;

public class CandleStick
implements PriceChange,
Candle {
    private Type type = Type.UNDEFINED;
    private PriceChangeType priceChangeType = PriceChangeType.UNDEFINED;
    protected BigDecimal open;
    protected BigDecimal close;
    protected BigDecimal high = null;
    protected BigDecimal low = null;
    protected BigDecimal change = null;
    protected BigDecimal changeRate = null;
    protected BigDecimal previous = null;
    private long openTime;
    private long closeTime;
    protected boolean isEndTrade = false;

    public Type getType() {
        return this.type;
    }

    public void setType(BigDecimal shortGap, BigDecimal steadyGap) {
        BigDecimal rate;
        BigDecimal lowerShadow;
        BigDecimal upperShadow;
        BigDecimal height = this.getHeight();
        if (height.compareTo(steadyGap) <= 0) {
            this.type = Type.STEADY;
            return;
        }
        BigDecimal absChange = this.change.abs();
        this.priceChangeType = absChange.compareTo(steadyGap) < 0 ? PriceChangeType.HOLD : (this.change.compareTo(BigDecimal.ZERO) > 0 ? PriceChangeType.RISE : PriceChangeType.FALL);
        BigDecimal decimal_2 = new BigDecimal(2);
        if (this.change.compareTo(BigDecimal.ZERO) < 0) {
            upperShadow = this.high.subtract(this.open);
            lowerShadow = this.close.subtract(this.low);
        } else {
            upperShadow = this.high.subtract(this.close);
            lowerShadow = this.open.subtract(this.low);
        }
        if (upperShadow.compareTo(lowerShadow) > 0 && upperShadow.compareTo(absChange) > 0 && upperShadow.compareTo(steadyGap) > 0) {
            if (lowerShadow.compareTo(steadyGap) < 0) {
                this.type = Type.UPPER_SHADOW;
                return;
            }
            rate = upperShadow.divide(lowerShadow, MathContext.DECIMAL128);
            if (rate.compareTo(decimal_2) >= 0) {
                this.type = Type.UPPER_SHADOW;
                return;
            }
        }
        if (lowerShadow.compareTo(upperShadow) > 0 && lowerShadow.compareTo(absChange) > 0 && lowerShadow.compareTo(steadyGap) > 0) {
            if (upperShadow.compareTo(steadyGap) < 0) {
                this.type = Type.LOWER_SHADOW;
                return;
            }
            rate = lowerShadow.divide(upperShadow, MathContext.DECIMAL128);
            if ((double)rate.compareTo(decimal_2) >= 2.0) {
                this.type = Type.LOWER_SHADOW;
                return;
            }
        }
        if (lowerShadow.compareTo(absChange) > 0 && upperShadow.compareTo(absChange) > 0 && lowerShadow.compareTo(steadyGap) > 0 && upperShadow.compareTo(steadyGap) > 0) {
            if (absChange.compareTo(steadyGap) < 0) {
                this.type = Type.DOJI;
                return;
            }
            BigDecimal upperRate = upperShadow.divide(absChange, MathContext.DECIMAL128);
            BigDecimal lowerRate = lowerShadow.divide(absChange, MathContext.DECIMAL128);
            this.type = upperRate.compareTo(decimal_2) >= 0 && lowerRate.compareTo(decimal_2) >= 0 ? Type.HIGH_WAVE : Type.SPINNING_TOPS;
            return;
        }
        this.type = absChange.compareTo(shortGap) <= 0 ? Type.SHORT : Type.LONG;
    }

    public PriceChangeType getPriceChangeType() {
        return this.priceChangeType;
    }

    public void setPriceChangeType(PriceChangeType priceChangeType) {
        this.priceChangeType = priceChangeType;
    }

    @Override
    public BigDecimal getOpen() {
        return this.open;
    }

    public void setOpen(BigDecimal open) {
        this.open = open;
    }

    @Override
    public BigDecimal getClose() {
        return this.close;
    }

    public void setClose(BigDecimal close) {
        this.close = close;
    }

    @Override
    public BigDecimal getHigh() {
        return this.high;
    }

    public void setHigh(BigDecimal high) {
        this.high = high;
    }

    @Override
    public BigDecimal getLow() {
        return this.low;
    }

    public void setLow(BigDecimal low) {
        this.low = low;
    }

    public BigDecimal getHeight() {
        return this.high.subtract(this.low);
    }

    public void setChange(BigDecimal change) {
        this.change = change;
    }

    @Override
    public BigDecimal getPrevious() {
        if (this.previous == null && this.change != null) {
            this.previous = this.open.subtract(this.change);
        }
        return this.previous;
    }

    public void setPrevious(BigDecimal previous) {
        this.previous = previous;
    }

    public void setPrevious() {
        this.previous = this.close.subtract(this.change);
    }

    public void setChange() {
        this.change = this.close.subtract(this.previous);
        this.changeRate = this.change.divide(this.previous, MathContext.DECIMAL128);
    }

    @Override
    public BigDecimal getChange() {
        return this.change;
    }

    public void setChangeRate(BigDecimal changeRate) {
        this.changeRate = changeRate;
    }

    public BigDecimal changeAbs() {
        return this.change.abs();
    }

    @Override
    public BigDecimal getChangeRate() {
        if (this.isEndTrade && this.changeRate != null) {
            return this.changeRate;
        }
        this.changeRate = this.change.divide(this.getPrevious(), MathContext.DECIMAL128);
        return this.changeRate;
    }

    public BigDecimal getUpperTail() {
        return this.high.subtract(this.open.max(this.close));
    }

    public BigDecimal getLowerTail() {
        return this.open.max(this.close).subtract(this.low);
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public void setOpenTime(long openTime) {
        this.openTime = openTime;
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(long closeTime) {
        this.closeTime = closeTime;
    }

    public boolean isEndTrade() {
        return this.isEndTrade;
    }

    public void setEndTrade() {
        this.isEndTrade = true;
    }

    public static enum Type {
        UNDEFINED,
        STEADY,
        LONG,
        SHORT,
        UPPER_SHADOW,
        LOWER_SHADOW,
        HIGH_WAVE,
        SPINNING_TOPS,
        DOJI;

    }
}

