/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.view;

import com.seomse.commons.utils.FileUtil;
import com.seomse.commons.utils.time.DateUtil;
import io.runon.trading.PriceOpenTime;
import io.runon.trading.technical.analysis.candle.CandleStick;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.view.Lines;
import io.runon.trading.view.MarkerData;
import io.runon.trading.view.VolumeData;
import io.runon.trading.view.util.BrowserUtil;
import io.runon.trading.view.util.JarUtil;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TradingChart {
    CandleStick[] candleStickArr;
    StringBuilder createChartStr = new StringBuilder();
    ChartDateType dateType;
    String pureJsContents = JarUtil.readFromJarFile("pure.js");
    String lightWeightJsContents = JarUtil.readFromJarFile("lightweight-charts.standalone.production.js");
    String browserTitle = "runon LightWeight-Chart View";
    String exportPath = "data";
    static final String LEFT_LINE_REPLACER = "$$LEFT_LINE_REPLACER$$";
    static final String JS_CHART_VALUE = "$chart";
    static final String JS_CANDLE_VALUE = "$candlestickSeries";
    static final String JS_VOLUME_VALUE = "$volumeSeries";
    static final String JS_MARKER_VALUE = "$markers";
    boolean leftLineEnabled = false;
    int chartCount = 1;
    private List<MarkerData> markerDataList = null;
    private Map<Integer, List<MarkerData>> markerMap = null;

    public StringBuilder getCreateChartStr() {
        return this.createChartStr;
    }

    public void addAnotherChart(TradingChart anotherChart) {
        ++this.chartCount;
        if (this.markerMap == null) {
            this.markerMap = new HashMap<Integer, List<MarkerData>>();
        }
        String anotherChartStr = anotherChart.getCreateChartStr().toString();
        anotherChartStr = anotherChartStr.replace(JS_CHART_VALUE, JS_CHART_VALUE + this.chartCount);
        anotherChartStr = anotherChartStr.replace(JS_CANDLE_VALUE, JS_CANDLE_VALUE + this.chartCount);
        anotherChartStr = anotherChartStr.replace(JS_VOLUME_VALUE, JS_VOLUME_VALUE + this.chartCount);
        anotherChartStr = anotherChartStr.replace(JS_MARKER_VALUE, JS_MARKER_VALUE + this.chartCount);
        this.createChartStr.append(anotherChartStr);
        this.markerMap.put(this.chartCount, anotherChart.markerDataList);
    }

    public void setBrowserTitle(String browserTitle) {
        this.browserTitle = browserTitle;
    }

    public TradingChart(CandleStick[] candleStickArr) {
        this(candleStickArr, 600, 300, ChartDateType.DAY);
    }

    public TradingChart(CandleStick[] candleStickArr, int width, int height, ChartDateType dateType) {
        this.candleStickArr = candleStickArr;
        this.dateType = dateType;
        this.createChartStr.append("var $chart = LightweightCharts.createChart(document.body, {\n    width: %d,\n  height: %d,\n  %s\n  crosshair: {\n    mode: LightweightCharts.CrosshairMode.Normal,\n  }\n});\n\nconst $candlestickSeries = $chart.addCandlestickSeries({\n  priceScaleId: 'right'\n});\n\n\n".formatted(width, height, LEFT_LINE_REPLACER));
        if (dateType == ChartDateType.MINUTE) {
            this.createChartStr.append("$chart.applyOptions({\n        timeScale: {\n            // Adds hours and minutes to the chart.\n            timeVisible: true,\n            secondsVisible: false\n        }\n    });\n");
        }
        this.createChartStr.append("$candlestickSeries.setData([");
        for (CandleStick candleStick : candleStickArr) {
            String timeStr = Long.toString(candleStick.getOpenTime() / 1000L);
            this.createChartStr.append("{\n    close: %s,\n    high: %s,\n    low: %s,\n    open: %s,\n    time: %s\n  },\n".formatted(candleStick.getClose().stripTrailingZeros().toString(), candleStick.getHigh().stripTrailingZeros().toString(), candleStick.getLow().stripTrailingZeros().toString(), candleStick.getOpen().stripTrailingZeros().toString(), timeStr));
        }
        this.createChartStr.setLength(this.createChartStr.length() - 1);
        this.createChartStr.append("]);\n");
    }

    public void addVolume(TradeCandle[] candles) {
        VolumeData[] volumeDataArr = new VolumeData[candles.length];
        for (int i = 0; i < candles.length; ++i) {
            TradeCandle candle = candles[i];
            VolumeData volumeData = new VolumeData();
            volumeData.volume = candles[i].getVolume();
            volumeData.time = candles[i].getOpenTime();
            volumeData.color = candle.getChange().compareTo(BigDecimal.ZERO) >= 0 ? "#26a69a" : "red";
            volumeDataArr[i] = volumeData;
        }
        this.addVolume(volumeDataArr, new BigDecimal("0.85"), BigDecimal.ZERO);
    }

    public void addVolume(VolumeData[] volumeDataArr, BigDecimal topMargin, BigDecimal bottomMargin) {
        this.createChartStr.append("var $volumeSeries = $chart.addHistogramSeries({\n  \tcolor: '#26a69a',\n  \tpriceFormat: {\n  \t\ttype: 'volume',\n  \t},\n  \tpriceScaleId: '',\n  \tscaleMargins: {\n  \t\ttop: %s,\n  \t\tbottom: %s,\n  \t},\n  });\n  $volumeSeries.setData([\n".formatted(topMargin.setScale(1, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString(), bottomMargin.setScale(1, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()));
        for (VolumeData volumeData : volumeDataArr) {
            String timeStr = Long.toString(volumeData.getTime() / 1000L);
            this.createChartStr.append("{ time: %s, value: %s, color: '%s' },\n".formatted(timeStr, volumeData.getVolume().setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString(), volumeData.getColor()));
        }
        this.createChartStr.append("]);");
    }

    public void addLine(PriceOpenTime[] lineDataArr, String color, int size) {
        this.addLine(lineDataArr, color, size, true, true);
    }

    public void addLine(PriceOpenTime[] lineDataArr, String color, int size, boolean rightSide) {
        this.addLine(lineDataArr, color, size, rightSide, true);
    }

    public void addLine(Lines lines) {
        this.addLine(lines.lines, lines.color, lines.size, lines.rightSide, lines.isValueVisible);
    }

    public void addLine(PriceOpenTime[] lineDataArr, String color, int size, boolean rightSide, boolean isValueVisible) {
        if (isValueVisible) {
            this.createChartStr.append("$chart.addLineSeries({\n  color: '%s',\n  lineWidth: %d,\n  priceScaleId: '%s'\n}).setData([\n".formatted(color, size, rightSide ? "right" : "left"));
        } else {
            this.createChartStr.append("$chart.addLineSeries({\n  color: '%s',\n  lineWidth: %d,\n  priceScaleId: '%s',\n  priceLineVisible: false,\n  lastValueVisible: false\n}).setData([\n".formatted(color, size, rightSide ? "right" : "left"));
        }
        if (!rightSide) {
            this.createChartStr = new StringBuilder(this.createChartStr.toString().replace(LEFT_LINE_REPLACER, "leftPriceScale: {visible: true, },"));
        }
        for (PriceOpenTime lineData : lineDataArr) {
            BigDecimal price = lineData.getClose();
            String timeStr = Long.toString(lineData.getOpenTime() / 1000L);
            this.createChartStr.append("{\n    time: %s,\n    value: %s\n  },\n".formatted(timeStr, price.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()));
        }
        this.createChartStr.setLength(this.createChartStr.length() - 1);
        this.createChartStr.append("]);\n");
    }

    public String getHtml() {
        StringBuilder result = new StringBuilder("<!DOCTYPE html>\n<html>\n<head>\n  <title>%s</title>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n</head>\n<body>\n    <script>%s</script>\n    <script>%s</script>\n\n".formatted(this.browserTitle, this.pureJsContents, this.lightWeightJsContents));
        if (this.chartCount > 1) {
            for (int i = 2; i <= this.chartCount; ++i) {
                this.createChartStr.append("\n$chart.timeScale().subscribeVisibleLogicalRangeChange(range => {\n  %s.timeScale().setVisibleLogicalRange(range)\n});\n\n%s.timeScale().subscribeVisibleLogicalRangeChange(range => {\n  $chart.timeScale().setVisibleLogicalRange(range)\n});\n\n".formatted(JS_CHART_VALUE + i, JS_CHART_VALUE + i));
            }
        }
        result.append("<script>\n").append(this.createChartStr.toString().replace(LEFT_LINE_REPLACER, "")).append("\n</script>\n");
        return result.append("</body></html>").toString();
    }

    public List<MarkerData> getMarkerDataList() {
        return this.markerDataList;
    }

    public void addMarker(MarkerData[] markerDataArray) {
        if (this.markerDataList == null) {
            this.markerDataList = new ArrayList<MarkerData>();
        }
        Collections.addAll(this.markerDataList, markerDataArray);
    }

    public void addMarker(MarkerData markerData) {
        if (this.markerDataList == null) {
            this.markerDataList = new ArrayList<MarkerData>();
        }
        this.markerDataList.add(markerData);
    }

    public void addMarker(List<MarkerData> list) {
        if (this.markerDataList == null) {
            this.markerDataList = new ArrayList<MarkerData>();
        }
        this.markerDataList.addAll(list);
    }

    public void setMarker() {
        if (this.markerMap == null) {
            this.markerMap = new HashMap<Integer, List<MarkerData>>();
        }
        this.markerMap.put(0, this.markerDataList);
        for (int i = 0; i < this.chartCount; ++i) {
            List<MarkerData> chartMarkerList = this.markerMap.get(i);
            if (chartMarkerList == null || chartMarkerList.size() == 0) continue;
            MarkerData[] array = chartMarkerList.toArray(new MarkerData[0]);
            Arrays.sort(array, MarkerData.SORT_TIME);
            String chartMarkerValue = JS_MARKER_VALUE + i;
            Object candleValue = JS_CANDLE_VALUE;
            if (i > 1) {
                candleValue = (String)candleValue + i;
            }
            this.createChartStr.append("var %s = [];\n".formatted(chartMarkerValue));
            for (MarkerData markerData : array) {
                String timeStr = Long.toString(markerData.getTime() / 1000L);
                this.createChartStr.append("%s.push({ time: %s, position: '%s', color: '%s', shape: '%s', text: '%s'});\n".formatted(chartMarkerValue, timeStr, markerData.getMarkerType().name(), markerData.getColor(), markerData.getMarkerShape().name(), markerData.getText()));
            }
            this.createChartStr.append("%s.setMarkers(%s);\n".formatted(candleValue, chartMarkerValue));
            this.markerDataList.clear();
        }
    }

    public String makeHtmlFile() {
        return this.makeHtmlFile(DateUtil.getDateYmd((long)System.currentTimeMillis(), (String)"yyyyMMddHHmmss") + ".html");
    }

    public String makeHtmlFile(String exportFileName) {
        this.setMarker();
        File exportDir = new File(this.exportPath);
        if (!exportDir.exists()) {
            exportDir.mkdir();
        }
        String exportFileFullPath = this.exportPath + "/" + exportFileName;
        FileUtil.fileOutput((String)this.getHtml(), (String)exportFileFullPath, (boolean)false);
        return exportFileFullPath;
    }

    public void view() {
        String exportFileFullPath = this.makeHtmlFile();
        File viewHtmlFile = new File(exportFileFullPath);
        String htmlFileAbsolutePath = viewHtmlFile.getAbsolutePath();
        BrowserUtil.loadChromeByFile(htmlFileAbsolutePath);
    }

    public static enum ChartDateType {
        MINUTE,
        DAY;

    }
}

