/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.view;

import com.seomse.commons.utils.FileUtil;
import com.seomse.commons.utils.time.DateUtil;
import io.runon.trading.technical.analysis.candle.CandleStick;
import io.runon.trading.view.LineData;
import io.runon.trading.view.MarkerData;
import io.runon.trading.view.VolumeData;
import io.runon.trading.view.util.BrowserUtil;
import io.runon.trading.view.util.JarUtil;
import java.io.File;

public class TradingChart {
    CandleStick[] candleStickArr;
    StringBuilder createChartStr = new StringBuilder();
    ChartDateType dateType;
    String pureJsContents = JarUtil.readFromJarFile("pure.js");
    String lightWeightJsContents = JarUtil.readFromJarFile("lightweight-charts.standalone.production.js");
    String browserTitle = "Seomse LightWeight-Chart View";
    String exportPath = "data";

    public void setBrowserTitle(String browserTitle) {
        this.browserTitle = browserTitle;
    }

    public TradingChart(CandleStick[] candleStickArr) {
        this(candleStickArr, 600, 300, ChartDateType.DAY);
    }

    public TradingChart(CandleStick[] candleStickArr, int width, int height, ChartDateType dateType) {
        this.candleStickArr = candleStickArr;
        this.dateType = dateType;
        this.createChartStr.append("var chart = LightweightCharts.createChart(document.body, {\n    width: %d,\n  height: %d,\n  crosshair: {\n    mode: LightweightCharts.CrosshairMode.Normal,\n  }\n});\n\nconst candlestickSeries = chart.addCandlestickSeries({\n  priceScaleId: 'right'\n});\n".formatted(width, height));
        this.createChartStr.append("candlestickSeries.setData([");
        for (CandleStick candleStick : candleStickArr) {
            String timeStr = dateType.equals((Object)ChartDateType.DAY) ? DateUtil.getDateYmd((long)candleStick.getOpenTime(), (String)"yyyy-MM-dd") : DateUtil.getDateYmd((long)candleStick.getOpenTime(), (String)"yyyy-MM-dd HH:mm");
            this.createChartStr.append("{\n    close: %s,\n    high: %s,\n    low: %s,\n    open: %s,\n    time: '%s'\n  },\n".formatted(candleStick.getClose().stripTrailingZeros().toString(), candleStick.getHigh().stripTrailingZeros().toString(), candleStick.getLow().stripTrailingZeros().toString(), candleStick.getOpen().stripTrailingZeros().toString(), timeStr));
        }
        this.createChartStr.setLength(this.createChartStr.length() - 1);
        this.createChartStr.append("]);\n");
    }

    public void addMarkerAll(MarkerData[] markerDataArray) {
        this.createChartStr.append("var markers = [];\n");
        for (MarkerData markerData : markerDataArray) {
            String timeStr = this.dateType.equals((Object)ChartDateType.DAY) ? DateUtil.getDateYmd((long)markerData.getTime(), (String)"yyyy-MM-dd") : DateUtil.getDateYmd((long)markerData.getTime(), (String)"yyyy-MM-dd HH:mm");
            this.createChartStr.append("markers.push({ time: '%s', position: '%s', color: '%s', shape: '%s', text: '%s'});\n".formatted(timeStr, markerData.getMarkerType().name(), markerData.getColor(), markerData.getMarkerShape().name(), markerData.getText()));
        }
        this.createChartStr.append("candlestickSeries.setMarkers(markers);");
    }

    public void addVolumeAll(VolumeData[] volumeDataArr, double topMargin, double bottomMargin) {
        this.createChartStr.append("var volumeSeries = chart.addHistogramSeries({\n  \tcolor: '#26a69a',\n  \tpriceFormat: {\n  \t\ttype: 'volume',\n  \t},\n  \tpriceScaleId: '',\n  \tscaleMargins: {\n  \t\ttop: %.1f,\n  \t\tbottom: %.1f,\n  \t},\n  });\n  volumeSeries.setData([\n".formatted(topMargin, bottomMargin));
        for (VolumeData volumeData : volumeDataArr) {
            String timeStr = this.dateType.equals((Object)ChartDateType.DAY) ? DateUtil.getDateYmd((long)volumeData.getTime(), (String)"yyyy-MM-dd") : DateUtil.getDateYmd((long)volumeData.getTime(), (String)"yyyy-MM-dd HH:mm");
            this.createChartStr.append("{ time: '%s', value: %.2f, color: '%s' },\n".formatted(timeStr, volumeData.getVolume(), volumeData.getColor()));
        }
        this.createChartStr.append("]);");
    }

    public void addLineAll(LineData[] lineDataArr, String color, int size) {
        this.createChartStr.append("chart.addLineSeries({\n  color: '%s',\n  lineWidth: %d,\n}).setData([\n".formatted(color, size));
        for (LineData lineData : lineDataArr) {
            double price = lineData.getPrice();
            String timeStr = this.dateType.equals((Object)ChartDateType.DAY) ? DateUtil.getDateYmd((long)lineData.getTime(), (String)"yyyy-MM-dd") : DateUtil.getDateYmd((long)lineData.getTime(), (String)"yyyy-MM-dd HH:mm");
            this.createChartStr.append("{\n    time: '%s',\n    value: %.2f\n  },\n".formatted(timeStr, price));
        }
        this.createChartStr.setLength(this.createChartStr.length() - 1);
        this.createChartStr.append("]);\n");
    }

    public String getHtml() {
        StringBuilder result = new StringBuilder("<!DOCTYPE html>\n<html>\n<head>\n  <title>%s</title>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n</head>\n<body>\n    <script>%s</script>\n    <script>%s</script>\n\n".formatted(this.browserTitle, this.pureJsContents, this.lightWeightJsContents));
        result.append("<script>\n").append(this.createChartStr.toString()).append("\n</script>\n");
        return result.append("</body></html>").toString();
    }

    public String makeHtmlFile() {
        return this.makeHtmlFile(DateUtil.getDateYmd((long)System.currentTimeMillis(), (String)"yyyyMMddHHmmss") + ".html");
    }

    public String makeHtmlFile(String exportFileName) {
        File exportDir = new File(this.exportPath);
        if (!exportDir.exists()) {
            exportDir.mkdir();
        }
        String exportFileFullPath = this.exportPath + "/" + exportFileName;
        FileUtil.fileOutput((String)this.getHtml(), (String)exportFileFullPath, (boolean)false);
        return exportFileFullPath;
    }

    public void view() {
        String exportFileFullPath = this.makeHtmlFile();
        File viewHtmlFile = new File(exportFileFullPath);
        String htmlFileAbsolutePath = viewHtmlFile.getAbsolutePath();
        BrowserUtil.loadChromeByFile(htmlFileAbsolutePath);
    }

    public static enum ChartDateType {
        MINUTE,
        DAY;

    }
}

