/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.backtesting.price.symbol;

import io.runon.trading.Candle;
import io.runon.trading.backtesting.price.symbol.CandleSymbolMapPrice;
import java.math.BigDecimal;
import java.util.Random;

public class SlippageRandomSymbolPrice
extends CandleSymbolMapPrice {
    private BigDecimal minRate = new BigDecimal("0.2");

    public void setMinRate(BigDecimal minRate) {
        if (minRate.compareTo(BigDecimal.ONE) > 0) {
            throw new IllegalArgumentException("between 0 and 1: " + minRate.toPlainString());
        }
        this.minRate = minRate;
    }

    @Override
    public BigDecimal getBuyPrice(String symbol) {
        Candle candle = (Candle)this.candleMap.get(symbol);
        BigDecimal gap = candle.getHigh().subtract(candle.getClose());
        BigDecimal min = gap.multiply(this.minRate);
        if (min.compareTo(BigDecimal.ZERO) == 0) {
            return candle.getClose().add(min);
        }
        BigDecimal random = BigDecimal.valueOf(new Random().nextDouble(gap.subtract(min).doubleValue()));
        return candle.getClose().add(min).add(random);
    }

    @Override
    public BigDecimal getSellPrice(String symbol) {
        Candle candle = (Candle)this.candleMap.get(symbol);
        BigDecimal gap = candle.getClose().subtract(candle.getLow());
        BigDecimal min = gap.multiply(this.minRate);
        if (min.compareTo(BigDecimal.ZERO) == 0) {
            return candle.getClose().subtract(min);
        }
        BigDecimal random = BigDecimal.valueOf(new Random().nextDouble(gap.subtract(min).doubleValue()));
        return candle.getClose().subtract(min).subtract(random);
    }
}

