/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.backtesting.account;

import io.runon.trading.Trade;
import io.runon.trading.account.Account;
import io.runon.trading.backtesting.account.SpotBacktestingHolding;
import io.runon.trading.backtesting.price.symbol.SymbolPrice;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SpotBacktestingAccount
implements Account {
    protected BigDecimal cash = BigDecimal.ZERO;
    protected BigDecimal buyFee = new BigDecimal("0.00245");
    protected BigDecimal sellFee = new BigDecimal("0.00015");
    protected final Map<String, SpotBacktestingHolding> holdingMap = new HashMap<String, SpotBacktestingHolding>();
    protected final Object lock = new Object();
    private final String id;
    protected SymbolPrice symbolPrice;

    public void setFee(BigDecimal fee) {
        this.buyFee = fee;
        this.sellFee = fee;
    }

    public void setBuyFee(BigDecimal buyFee) {
        this.buyFee = buyFee;
    }

    public void setSellFee(BigDecimal sellFee) {
        this.sellFee = sellFee;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public void addCash(BigDecimal cash) {
        this.cash = this.cash.add(cash);
    }

    public SpotBacktestingAccount(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trade(String symbol, Trade trade) {
        SpotBacktestingHolding holding;
        Object object = this.lock;
        synchronized (object) {
            holding = this.holdingMap.get(symbol);
            if (holding == null) {
                holding = new SpotBacktestingHolding();
                this.holdingMap.put(symbol, holding);
            }
            if (trade.getType() == Trade.Type.BUY) {
                BigDecimal buyCash = trade.getPrice().multiply(trade.getVolume()).add(this.getBuyFee(holding, trade.getPrice(), trade.getVolume()));
                this.cash = this.cash.subtract(buyCash);
            } else {
                BigDecimal sellCash = trade.getPrice().multiply(trade.getVolume()).subtract(this.getSellFee(holding, trade.getPrice(), trade.getVolume()));
                this.cash = this.cash.add(sellCash);
            }
        }
        holding.trade(trade);
        if (holding.amount.compareTo(BigDecimal.ZERO) <= 0) {
            object = this.lock;
            synchronized (object) {
                this.holdingMap.remove(symbol);
            }
        }
    }

    public BigDecimal getBuyFee(SpotBacktestingHolding holding, BigDecimal price, BigDecimal volume) {
        return price.multiply(volume).multiply(this.buyFee);
    }

    public BigDecimal getSellFee(SpotBacktestingHolding holding, BigDecimal price, BigDecimal volume) {
        return price.multiply(volume).multiply(this.sellFee);
    }

    public void setSymbolPrice(SymbolPrice symbolPrice) {
        this.symbolPrice = symbolPrice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getAssets() {
        Object object = this.lock;
        synchronized (object) {
            BigDecimal assets = this.cash;
            Collection<SpotBacktestingHolding> holdings = this.holdingMap.values();
            for (SpotBacktestingHolding holding : holdings) {
                BigDecimal price = this.symbolPrice.getPrice(holding.getSymbol());
                assets = assets.add(holding.getAmount().multiply(price).subtract(this.getSellFee(holding, price, holding.getAmount())));
            }
            return assets;
        }
    }

    public String getId() {
        return this.id;
    }

    public BigDecimal getCash() {
        return this.cash;
    }
}

