/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.backtesting.account;

import io.runon.trading.account.FuturesAccount;
import io.runon.trading.account.FuturesPosition;
import io.runon.trading.account.FuturesPositionData;
import io.runon.trading.backtesting.price.symbol.SymbolPrice;
import io.runon.trading.order.Order;
import io.runon.trading.strategy.Position;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuturesBacktestingAccount
implements FuturesAccount {
    private static final Logger log = LoggerFactory.getLogger(FuturesBacktestingAccount.class);
    protected BigDecimal cash = BigDecimal.ZERO;
    protected final String id;
    protected final Map<String, FuturesPositionData> positionMap = new HashMap<String, FuturesPositionData>();
    protected SymbolPrice symbolPrice;
    protected BigDecimal minPrice = BigDecimal.ONE;
    protected final Map<String, Integer> symbolQuantityPrecision = new HashMap<String, Integer>();
    protected int scale = 6;
    protected int priceScale = 2;
    protected BigDecimal buyFee = new BigDecimal("0.0004");
    protected BigDecimal sellFee = new BigDecimal("0.0004");

    public FuturesBacktestingAccount(String id) {
        this.id = id;
    }

    public FuturesBacktestingAccount() {
        this.id = "backtesting";
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public void addCash(BigDecimal cash) {
        this.cash = this.cash.add(cash);
    }

    public void setSymbolPrice(SymbolPrice symbolPrice) {
        this.symbolPrice = symbolPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public void setQuantityPrecision(String symbol, Integer quantityPrecision) {
        this.symbolQuantityPrecision.put(symbol, quantityPrecision);
    }

    public int getQuantityPrecision(String symbol) {
        Integer quantityPrecision = this.symbolQuantityPrecision.get(symbol);
        if (quantityPrecision == null) {
            this.symbolQuantityPrecision.put(symbol, 3);
            return 3;
        }
        return quantityPrecision;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setPriceScale(int priceScale) {
        this.priceScale = priceScale;
    }

    public void setBuyFee(BigDecimal buyFee) {
        this.buyFee = buyFee;
    }

    public void setSellFee(BigDecimal sellFee) {
        this.sellFee = sellFee;
    }

    public void setFee(BigDecimal fee) {
        this.buyFee = fee;
        this.sellFee = fee;
    }

    public void order(String symbol, Order order) {
        Position position = order.getPosition();
        if (position == Position.LONG) {
            BigDecimal price = this.symbolPrice.getBuyPrice(symbol);
            BigDecimal orderPrice = this.shortClose(symbol, order.getPrice(), price);
            if (orderPrice.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            if (orderPrice.compareTo(this.cash) > 0) {
                orderPrice = this.cash;
            }
            this.buy(symbol, orderPrice.subtract(orderPrice.multiply(this.buyFee)), price);
        } else if (position == Position.SHORT) {
            BigDecimal price = this.symbolPrice.getSellPrice(symbol);
            BigDecimal orderPrice = this.longClose(symbol, order.getPrice(), price);
            if (orderPrice.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            System.out.println("orderp: " + orderPrice.toPlainString());
            if (orderPrice.compareTo(this.cash) > 0) {
                orderPrice = this.cash;
            }
            this.sell(symbol, orderPrice.subtract(orderPrice.multiply(this.sellFee)), price);
        } else if (position == Position.LONG_CLOSE) {
            this.longClose(symbol, order.getPrice(), null);
        } else if (position == Position.SHORT_CLOSE) {
            this.shortClose(symbol, order.getPrice(), null);
        }
    }

    public void buyAll(String symbol) {
        this.shortClose(symbol);
        this.buy(symbol, this.cash.subtract(this.cash.multiply(this.buyFee)), null);
    }

    public void buy(String symbol, BigDecimal buyCash, BigDecimal price) {
        BigDecimal quantity;
        if (buyCash.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (price == null) {
            price = this.symbolPrice.getBuyPrice(symbol);
        }
        if ((quantity = buyCash.divide(price, this.getQuantityPrecision(symbol), RoundingMode.DOWN)).compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        FuturesPositionData futuresPositionData = this.positionMap.get(symbol);
        BigDecimal tradingPrice = price.multiply(quantity);
        if (futuresPositionData == null) {
            futuresPositionData = new FuturesPositionData();
            futuresPositionData.setSymbol(symbol);
            futuresPositionData.setPrice(price);
            futuresPositionData.setQuantity(quantity);
            futuresPositionData.setTradingPrice(tradingPrice);
            futuresPositionData.setPosition(Position.LONG);
            futuresPositionData.setLeverage(BigDecimal.ONE);
            this.positionMap.put(symbol, futuresPositionData);
        } else {
            futuresPositionData.setQuantity(futuresPositionData.getQuantity().add(quantity));
            futuresPositionData.setTradingPrice(futuresPositionData.getTradingPrice().add(tradingPrice));
            futuresPositionData.setPrice(futuresPositionData.getTradingPrice().divide(futuresPositionData.getQuantity(), MathContext.DECIMAL128));
        }
        this.cash = this.cash.subtract(tradingPrice).subtract(tradingPrice.multiply(this.buyFee));
    }

    public void sellAll(String symbol) {
        this.longClose(symbol);
        this.sell(symbol, this.cash.subtract(this.cash.multiply(this.sellFee)), null);
    }

    public void sell(String symbol, BigDecimal sellCash, BigDecimal price) {
        BigDecimal quantity;
        if (sellCash.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (price == null) {
            price = this.symbolPrice.getBuyPrice(symbol);
        }
        if ((quantity = sellCash.divide(price, this.getQuantityPrecision(symbol), RoundingMode.DOWN)).compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal tradingPrice = price.multiply(quantity);
        FuturesPositionData futuresPositionData = this.positionMap.get(symbol);
        if (futuresPositionData == null) {
            futuresPositionData = new FuturesPositionData();
            futuresPositionData.setSymbol(symbol);
            futuresPositionData.setPrice(price);
            futuresPositionData.setQuantity(quantity);
            futuresPositionData.setTradingPrice(tradingPrice);
            futuresPositionData.setPosition(Position.SHORT);
            futuresPositionData.setLeverage(BigDecimal.ONE);
            this.positionMap.put(symbol, futuresPositionData);
        } else {
            futuresPositionData.setQuantity(futuresPositionData.getQuantity().add(quantity));
            futuresPositionData.setTradingPrice(futuresPositionData.getTradingPrice().add(tradingPrice));
            futuresPositionData.setPrice(futuresPositionData.getTradingPrice().divide(futuresPositionData.getQuantity(), MathContext.DECIMAL128));
        }
        this.cash = this.cash.subtract(tradingPrice).subtract(tradingPrice.multiply(this.sellFee));
    }

    public void close(String symbol) {
        FuturesPositionData futuresPositionData = this.positionMap.get(symbol);
        if (futuresPositionData == null) {
            return;
        }
        this.positionMap.remove(symbol);
        BigDecimal closePrice = this.closePrice(futuresPositionData);
        this.cash = this.cash.add(closePrice);
    }

    public void shortClose(String symbol) {
        FuturesPositionData futuresPositionData = this.positionMap.get(symbol);
        if (futuresPositionData == null) {
            return;
        }
        if (futuresPositionData.getPosition() != Position.SHORT) {
            return;
        }
        this.positionMap.remove(symbol);
        BigDecimal closePrice = this.closePrice(futuresPositionData);
        this.cash = this.cash.add(closePrice);
    }

    public BigDecimal shortClose(String symbol, BigDecimal orderPrice, BigDecimal price) {
        FuturesPositionData futuresPositionData = this.positionMap.get(symbol);
        if (futuresPositionData == null) {
            return orderPrice;
        }
        if (futuresPositionData.getPosition() != Position.SHORT) {
            return orderPrice;
        }
        if (price == null || price.compareTo(BigDecimal.ZERO) == 0) {
            price = this.symbolPrice.getBuyPrice(symbol);
        }
        BigDecimal quantity = orderPrice.divide(price, this.getQuantityPrecision(symbol), RoundingMode.DOWN);
        int compare = futuresPositionData.getQuantity().compareTo(quantity);
        if (compare == 0 || compare < 0) {
            this.positionMap.remove(symbol);
            BigDecimal closePrice = this.closePrice(futuresPositionData);
            this.cash = this.cash.add(closePrice);
            if (compare == 0) {
                return BigDecimal.ZERO;
            }
            return orderPrice.subtract(this.buyPrice(price, futuresPositionData.getQuantity()));
        }
        BigDecimal positionPrice = futuresPositionData.getPrice();
        BigDecimal rate = price.subtract(positionPrice).divide(positionPrice, MathContext.DECIMAL128);
        rate = rate.multiply(new BigDecimal(-1));
        BigDecimal closePrice = positionPrice.multiply(quantity);
        futuresPositionData.setQuantity(futuresPositionData.getQuantity().subtract(quantity));
        futuresPositionData.setTradingPrice(futuresPositionData.getTradingPrice().subtract(closePrice));
        closePrice = closePrice.add(closePrice.multiply(rate));
        closePrice = closePrice.subtract(orderPrice.multiply(this.buyFee));
        this.cash = this.cash.add(closePrice);
        return BigDecimal.ZERO;
    }

    public BigDecimal buyPrice(BigDecimal price, BigDecimal quantity) {
        BigDecimal tradingPrice = price.multiply(quantity);
        return tradingPrice.add(tradingPrice.multiply(this.buyFee));
    }

    public BigDecimal sellPrice(BigDecimal price, BigDecimal quantity) {
        BigDecimal tradingPrice = price.multiply(quantity);
        return tradingPrice.add(tradingPrice.multiply(this.sellFee));
    }

    public BigDecimal longClose(String symbol, BigDecimal orderPrice, BigDecimal price) {
        FuturesPositionData futuresPositionData = this.positionMap.get(symbol);
        if (futuresPositionData == null) {
            return orderPrice;
        }
        if (futuresPositionData.getPosition() != Position.LONG) {
            return orderPrice;
        }
        if (price == null || price.compareTo(BigDecimal.ZERO) == 0) {
            price = this.symbolPrice.getSellPrice(symbol);
        }
        BigDecimal quantity = orderPrice.divide(price, this.getQuantityPrecision(symbol), RoundingMode.DOWN);
        int compare = futuresPositionData.getQuantity().compareTo(quantity);
        if (compare == 0 || compare < 0) {
            this.positionMap.remove(symbol);
            BigDecimal closePrice = this.closePrice(futuresPositionData);
            this.cash = this.cash.add(closePrice);
            if (compare == 0) {
                return BigDecimal.ZERO;
            }
            System.out.println("sellPrice order price : " + orderPrice);
            System.out.println("sellPrice(price, quantity) " + this.sellPrice(price, futuresPositionData.getQuantity()));
            System.out.println(" orderPrice.subtract(sellPrice(price, quantity)) " + orderPrice.subtract(this.sellPrice(price, quantity)));
            return orderPrice.subtract(this.sellPrice(price, futuresPositionData.getQuantity()));
        }
        BigDecimal positionPrice = futuresPositionData.getPrice();
        BigDecimal rate = price.subtract(positionPrice).divide(positionPrice, MathContext.DECIMAL128);
        BigDecimal closePrice = futuresPositionData.getPrice().multiply(quantity);
        futuresPositionData.setQuantity(futuresPositionData.getQuantity().subtract(quantity));
        futuresPositionData.setTradingPrice(futuresPositionData.getTradingPrice().subtract(closePrice));
        closePrice = closePrice.add(closePrice.multiply(rate));
        closePrice = closePrice.subtract(orderPrice.multiply(this.sellFee));
        this.cash = this.cash.add(closePrice);
        return BigDecimal.ZERO;
    }

    public void longClose(String symbol) {
        FuturesPositionData futuresPositionData = this.positionMap.get(symbol);
        if (futuresPositionData == null) {
            return;
        }
        if (futuresPositionData.getPosition() != Position.LONG) {
            return;
        }
        this.positionMap.remove(symbol);
        BigDecimal closePrice = this.closePrice(futuresPositionData);
        this.cash = this.cash.add(closePrice);
    }

    public BigDecimal closePrice(String symbol) {
        FuturesPositionData futuresPositionData = this.positionMap.get(symbol);
        if (futuresPositionData == null) {
            return BigDecimal.ZERO;
        }
        return this.closePrice(futuresPositionData);
    }

    public BigDecimal closePrice(FuturesPositionData futuresPosition) {
        if (futuresPosition.getPrice().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        Position position = futuresPosition.getPosition();
        BigDecimal positionPrice = futuresPosition.getPrice();
        BigDecimal tradingPrice = futuresPosition.getTradingPrice();
        if (position == Position.LONG) {
            BigDecimal price = this.symbolPrice.getSellPrice(futuresPosition.getSymbol());
            BigDecimal rate = price.subtract(positionPrice).divide(positionPrice, MathContext.DECIMAL128);
            tradingPrice = tradingPrice.add(tradingPrice.multiply(rate));
            return tradingPrice.subtract(tradingPrice.multiply(this.sellFee));
        }
        if (position == Position.SHORT) {
            BigDecimal price = this.symbolPrice.getBuyPrice(futuresPosition.getSymbol());
            BigDecimal rate = price.subtract(positionPrice).divide(positionPrice, MathContext.DECIMAL128);
            rate = rate.multiply(new BigDecimal(-1));
            tradingPrice = tradingPrice.add(tradingPrice.multiply(rate));
            return tradingPrice.subtract(tradingPrice.multiply(this.buyFee));
        }
        return BigDecimal.ZERO;
    }

    public String getId() {
        return this.id;
    }

    public BigDecimal getAssets() {
        BigDecimal assets = this.cash;
        Collection<FuturesPositionData> holdings = this.positionMap.values();
        for (FuturesPositionData holding : holdings) {
            assets = assets.add(this.closePrice(holding));
        }
        return assets;
    }

    public BigDecimal getCash() {
        return this.cash;
    }

    public FuturesPosition getPosition(String symbol) {
        return (FuturesPosition)this.positionMap.get(symbol);
    }

    public void setLeverage(String symbol, BigDecimal leverage) {
        FuturesPositionData futuresPosition = this.positionMap.get(symbol);
        if (futuresPosition == null) {
            return;
        }
        futuresPosition.setLeverage(leverage);
    }

    public BigDecimal getLeverage(String symbol) {
        FuturesPositionData futuresPosition = this.positionMap.get(symbol);
        if (futuresPosition == null) {
            return BigDecimal.ZERO;
        }
        return futuresPosition.getLeverage();
    }

    public BigDecimal getAvailableBuyPrice(String symbol) {
        BigDecimal price = this.cash;
        if (this.getSymbolPosition(symbol) == Position.SHORT) {
            price = price.add(this.closePrice(symbol));
        }
        return price.subtract(price.multiply(this.buyFee));
    }

    public BigDecimal getAvailableSellPrice(String symbol) {
        BigDecimal price = this.cash;
        if (this.getSymbolPosition(symbol) == Position.LONG) {
            price = price.add(this.closePrice(symbol));
        }
        return price.subtract(price.multiply(this.buyFee));
    }

    public Position getSymbolPosition(String symbol) {
        FuturesPosition futuresPosition = (FuturesPosition)this.positionMap.get(symbol);
        if (futuresPosition == null) {
            return Position.NONE;
        }
        return futuresPosition.getPosition();
    }
}

