/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.backtesting;

import io.runon.trading.backtesting.FuturesBacktesting;
import io.runon.trading.backtesting.price.PriceCandle;
import io.runon.trading.backtesting.price.symbol.CandleSymbolPrice;
import io.runon.trading.backtesting.price.symbol.SlippageRandomSymbolPrice;
import io.runon.trading.strategy.Position;
import io.runon.trading.strategy.Strategy;
import io.runon.trading.technical.analysis.candle.CandleTime;
import java.math.BigDecimal;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FuturesSingleSymbolBacktesting<E extends PriceCandle>
extends FuturesBacktesting<E>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FuturesSingleSymbolBacktesting.class);
    protected Strategy<E> strategy;
    protected CandleSymbolPrice symbolPrice;
    protected long cycleTime = 60000L;
    protected ZoneId zoneId = ZoneId.of("Asia/Seoul");
    protected final long startTime;
    protected final long endTime;
    protected boolean isEnd = false;
    protected long lastValidTime;

    public void setStrategy(Strategy<E> strategy) {
        this.strategy = strategy;
    }

    public FuturesSingleSymbolBacktesting(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public FuturesSingleSymbolBacktesting(long startTime) {
        this.startTime = startTime;
        this.endTime = System.currentTimeMillis();
    }

    public void setSymbolPrice(CandleSymbolPrice symbolPrice) {
        this.symbolPrice = symbolPrice;
    }

    public void setCycleTime(long cycleTime) {
        this.cycleTime = cycleTime;
    }

    @Override
    public void run() {
        super.init();
        if (this.symbolPrice == null) {
            this.symbolPrice = new SlippageRandomSymbolPrice();
        }
        this.account.setSymbolPrice(this.symbolPrice);
        this.time = this.startTime;
        while (true) {
            this.changeTime(this.time);
            if (this.isEnd) {
                log.info(this.getLogMessage(this.symbolPrice.getPrice(this.symbol)));
                this.end();
                return;
            }
            this.symbolPrice.setPrice(this.symbol, ((PriceCandle)this.data).getPriceCandle());
            if (!((PriceCandle)this.data).isValid(this.time)) {
                this.time += this.cycleTime;
                if (this.time < this.endTime) continue;
                this.end();
                return;
            }
            this.lastValidTime = this.time;
            BigDecimal price = this.symbolPrice.getPrice(this.symbol);
            Position position = this.strategy.getPosition((Object)((PriceCandle)this.data));
            if (this.lastPosition == position || position == Position.NONE) {
                this.time += this.cycleTime;
                if (this.time >= this.endTime) {
                    this.end();
                    return;
                }
                this.addChartLine(price);
                continue;
            }
            this.changeChartLine(position);
            if (position == Position.LONG) {
                this.account.buyAll(this.symbol);
            } else if (position == Position.SHORT) {
                this.account.sellAll(this.symbol);
            } else if (position == Position.LONG_CLOSE) {
                this.account.longClose(this.symbol);
            } else if (position == Position.SHORT_CLOSE) {
                this.account.shortClose(this.symbol);
            } else if (position == Position.CLOSE) {
                this.account.close(this.symbol);
            }
            this.lastPosition = position;
            this.addChartLine(price);
            this.addChartMark(price);
            log.info(this.getLogMessage(price));
            this.time += this.cycleTime;
            if (this.time >= this.endTime) break;
        }
        this.end();
    }

    public abstract void changeTime(long var1);

    @Override
    protected void end() {
        log.info("backtesting end last valid time: " + CandleTime.ymdhm((long)this.lastValidTime, (ZoneId)this.zoneId));
        super.end();
    }
}

