/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.backtesting;

import io.runon.trading.TimePrice;
import io.runon.trading.account.FuturesPosition;
import io.runon.trading.backtesting.FuturesBacktesting;
import io.runon.trading.backtesting.account.FuturesBacktestingAccount;
import io.runon.trading.backtesting.price.TimePriceData;
import io.runon.trading.backtesting.price.symbol.SlippageRatePrice;
import io.runon.trading.data.TimeFileLineRead;
import io.runon.trading.order.Order;
import io.runon.trading.strategy.Position;
import io.runon.trading.strategy.StrategyOrder;
import io.runon.trading.technical.analysis.candle.CandleTimeGap;
import io.runon.trading.view.MarkerData;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FuturesReadBacktesting<E extends TimePrice, T extends TimePriceData>
extends FuturesBacktesting<T> {
    private static final Logger log = LoggerFactory.getLogger(FuturesReadBacktesting.class);
    protected final SlippageRatePrice slippageRatePrice = new SlippageRatePrice();
    protected StrategyOrder<T> strategy;
    private long candleOpenTime = 0L;

    public FuturesReadBacktesting() {
        this.account = new FuturesBacktestingAccount("test");
        this.account.addCash(new BigDecimal(10000));
        this.account.setSymbolPrice(this.slippageRatePrice);
    }

    public void setStrategy(StrategyOrder<T> strategy) {
        this.strategy = strategy;
    }

    public void start(String path) {
        this.init();
        final FuturesReadBacktesting obj = this;
        TimeFileLineRead lineRead = new TimeFileLineRead(){

            public void addLine(String line) {
                FuturesReadBacktesting.this.putData(FuturesReadBacktesting.this.make(line));
            }

            public void end() {
                obj.end();
            }
        };
        lineRead.read(path);
    }

    public void putData(E timePrice) {
        Order order;
        this.time = timePrice.getTime();
        long openTime = CandleTimeGap.getStartTime((long)60000L, (long)this.time);
        ((TimePriceData)this.data).setData(timePrice);
        this.slippageRatePrice.setPrice(this.symbol, timePrice);
        BigDecimal price = timePrice.getClose();
        if (openTime != this.candleOpenTime) {
            this.addChartLine(price);
            this.candleOpenTime = openTime;
        }
        if ((order = this.strategy.getPosition((Object)((TimePriceData)this.data))).getPrice().compareTo(BigDecimal.ZERO) == 0 || order.getPosition() == Position.NONE) {
            this.lastPosition = this.account.getSymbolPosition(this.symbol);
            return;
        }
        this.account.order(this.symbol, order);
        this.lastPosition = this.account.getSymbolPosition(this.symbol);
        if (this.isChart) {
            MarkerData.MarkerType markerType = MarkerData.MarkerType.aboveBar;
            MarkerData.MarkerShape markerShape = MarkerData.MarkerShape.arrowDown;
            String color = order.getPosition() == Position.LONG ? "#003300" : "#990000";
            MarkerData markerData = new MarkerData(this.time, color, order.getPosition().toString() + " " + order.getPrice() + " " + this.account.getAssets().setScale(2, RoundingMode.DOWN).stripTrailingZeros().toPlainString(), Long.toString(openTime), markerType, markerShape);
            this.addChartMark(markerData);
        }
        FuturesPosition futuresPosition = this.account.getPosition(this.symbol);
        log.info(this.getLogMessage(price));
    }

    public abstract E make(String var1);

    public void setSlippageRate(BigDecimal slippageRate) {
        this.slippageRatePrice.setRate(slippageRate);
    }

    public void setBuyFee(BigDecimal buyFee) {
        this.account.setBuyFee(buyFee);
    }

    public void setSellFee(BigDecimal sellFee) {
        this.account.setSellFee(sellFee);
    }
}

