/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.backtesting;

import io.runon.trading.BigDecimals;
import io.runon.trading.PriceOpenTime;
import io.runon.trading.backtesting.account.FuturesBacktestingAccount;
import io.runon.trading.strategy.Position;
import io.runon.trading.technical.analysis.candle.CandleStick;
import io.runon.trading.technical.analysis.candle.CandleTime;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.candle.candles.TradeCandles;
import io.runon.trading.view.LineData;
import io.runon.trading.view.Lines;
import io.runon.trading.view.MarkerData;
import io.runon.trading.view.TradingChart;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;

public abstract class FuturesBacktesting<E> {
    protected E data;
    protected FuturesBacktestingAccount account;
    protected String symbol = "test";
    protected ZoneId zoneId = ZoneId.of("Asia/Seoul");
    protected int cashScale = 2;
    protected BigDecimal subtractRate = new BigDecimal("0.1");
    protected long time;
    protected Position lastPosition = Position.NONE;
    protected BigDecimal startCash;
    protected boolean isChart = false;
    protected boolean isPositionLine = true;
    protected TradeCandle[] candles;
    protected List<LineData> assetList = null;
    protected List<MarkerData> markerDataList = null;
    protected List<Lines> linesList = null;
    protected List<LineData> lastLines = null;
    protected int chartWidth = 1200;
    protected int chartHeight = 800;

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setAccount(FuturesBacktestingAccount account) {
        this.account = account;
    }

    public void setCashScale(int cashScale) {
        this.cashScale = cashScale;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setData(E data) {
        this.data = data;
    }

    public void addCash(BigDecimal cash) {
        if (this.account == null) {
            this.account = new FuturesBacktestingAccount("test");
        }
        this.account.addCash(cash);
    }

    public void setChart(TradeCandle[] candles) {
        this.isChart = true;
        this.candles = candles;
    }

    public void setChart(TradeCandle[] candles, int length) {
        this.isChart = true;
        if (candles.length > length) {
            candles = TradeCandles.getCandles((TradeCandle[])candles, (int)(candles.length - 1), (int)length);
        }
        this.candles = candles;
    }

    public void setChartWidth(int chartWidth) {
        this.chartWidth = chartWidth;
    }

    public void setChartHeight(int chartHeight) {
        this.chartHeight = chartHeight;
    }

    protected void end() {
        if (this.isChart && this.candles.length > 0) {
            TradingChart chart = new TradingChart((CandleStick[])this.candles, this.chartWidth, this.chartHeight, TradingChart.ChartDateType.MINUTE);
            chart.addVolume(this.candles);
            this.addLines(this.linesList, this.lastLines);
            if (this.markerDataList.size() > 0) {
                chart.addMarker(this.markerDataList);
                chart.setMarker();
                this.markerDataList.clear();
            }
            if (this.assetList.size() > 0) {
                chart.addLine((PriceOpenTime[])this.assetList.toArray(new LineData[0]), "#3300FF", 1, false);
                this.assetList.clear();
            }
            if (this.isPositionLine && this.linesList.size() > 0) {
                for (Lines lines : this.linesList) {
                    chart.addLine(lines);
                }
                this.linesList.clear();
            }
            chart.view();
        }
    }

    protected void addLines(List<Lines> linesList, List<LineData> lastLines) {
        if (!this.isChart || !this.isPositionLine) {
            return;
        }
        if (lastLines.size() == 0) {
            return;
        }
        Lines lines = new Lines();
        lines.setLines((PriceOpenTime[])lastLines.toArray(new LineData[0]));
        String color = this.lastPosition == Position.LONG ? "#CCFFCC" : (this.lastPosition == Position.SHORT ? "#FF9999" : "#CCCCCC");
        lines.setColor(color);
        lines.setSize(8);
        lines.setValueVisible(false);
        linesList.add(lines);
        lastLines.clear();
    }

    protected void init() {
        if (this.account == null) {
            this.account = new FuturesBacktestingAccount("test");
            this.account.addCash(new BigDecimal(10000));
        } else if (this.account.getCash().compareTo(BigDecimal.ZERO) == 0) {
            this.account.addCash(new BigDecimal(10000));
        }
        this.startCash = this.account.getCash();
        if (this.isChart) {
            this.assetList = new ArrayList<LineData>();
            this.markerDataList = new ArrayList<MarkerData>();
            if (this.isPositionLine) {
                this.linesList = new ArrayList<Lines>();
                this.lastLines = new ArrayList<LineData>();
            }
        }
    }

    public void setPositionLine(boolean positionLine) {
        this.isPositionLine = positionLine;
    }

    protected void addChartLine(BigDecimal price) {
        if (this.isChart && this.time >= this.candles[0].getOpenTime()) {
            this.assetList.add(new LineData(BigDecimals.getChangePercent((BigDecimal)this.startCash, (BigDecimal)this.account.getAssets()), this.time));
            if (this.isPositionLine) {
                this.lastLines.add(new LineData(price, this.time));
            }
        }
    }

    public void changeChartLine(Position position) {
        if (this.isChart && this.isPositionLine && this.lastLines.size() > 0) {
            if (this.lastPosition == Position.LONG && position != Position.LONG) {
                this.addLines(this.linesList, this.lastLines);
            } else if (this.lastPosition == Position.SHORT && position != Position.SHORT) {
                this.addLines(this.linesList, this.lastLines);
            } else if (this.lastPosition != Position.LONG && this.lastPosition != Position.SHORT && (position == Position.LONG || position == Position.SHORT)) {
                this.addLines(this.linesList, this.lastLines);
            }
        }
    }

    public void addChartMark(BigDecimal price) {
        if (this.isChart && this.time >= this.candles[0].getOpenTime()) {
            MarkerData.MarkerType markerType = MarkerData.MarkerType.aboveBar;
            MarkerData.MarkerShape markerShape = MarkerData.MarkerShape.arrowDown;
            MarkerData markerData = new MarkerData(this.time, "black", this.lastPosition.toString() + " " + price.stripTrailingZeros().toPlainString(), Long.toString(this.time), markerType, markerShape);
            this.markerDataList.add(markerData);
        }
    }

    public void addChartMark(MarkerData markerData) {
        if (this.isChart && this.time >= this.candles[0].getOpenTime()) {
            this.markerDataList.add(markerData);
        }
    }

    public FuturesBacktestingAccount getAccount() {
        return this.account;
    }

    public String getLogMessage(BigDecimal price) {
        BigDecimal assets = this.account.getAssets();
        return CandleTime.ymdhm((long)this.time, (ZoneId)this.zoneId) + " " + this.lastPosition + " " + price + "\n" + assets.stripTrailingZeros().setScale(this.cashScale, RoundingMode.HALF_UP).toPlainString() + " " + BigDecimals.getChangePercent((BigDecimal)this.startCash, (BigDecimal)assets) + "%";
    }
}

