/*
 * Decompiled with CFR 0.152.
 */
package io.runon.classification.evaluation;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class ClassificationEvaluation {
    String id;
    String name;
    long tp;
    long tn;
    long fn;
    long fp;
    int scale = 4;

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public ClassificationEvaluation() {
        this.init();
    }

    public ClassificationEvaluation(long tp, long tn, long fn, long fp) {
        this.tp = tp;
        this.tn = tn;
        this.fn = fn;
        this.fp = fp;
    }

    public void init() {
        this.tp = 0L;
        this.tn = 0L;
        this.fn = 0L;
        this.fp = 0L;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTruePositive(long tp) {
        this.tp = tp;
    }

    public void setTrueNegative(long tn) {
        this.tn = tn;
    }

    public void setFalseNegative(long fn) {
        this.fn = fn;
    }

    public void setFalsePositive(long fp) {
        this.fp = fp;
    }

    public long getTruePositive() {
        return this.tp;
    }

    public long getTrueNegative() {
        return this.tn;
    }

    public long getFalseNegative() {
        return this.fn;
    }

    public long getFalsePositive() {
        return this.fp;
    }

    public void addTruePositive() {
        ++this.tp;
    }

    public void addTrueNegative() {
        ++this.tn;
    }

    public void addFalseNegative() {
        ++this.fn;
    }

    public void addFalsePositive() {
        ++this.fp;
    }

    public void addTruePositive(long tp) {
        this.tp += tp;
    }

    public void addTrueNegative(long tn) {
        this.tn += tn;
    }

    public void addFalseNegative(long fn) {
        this.fn += fn;
    }

    public void addFalsePositive(long fp) {
        this.fp += fp;
    }

    public void add(ClassificationEvaluation evaluation) {
        this.tp += evaluation.tp;
        this.tn += evaluation.tn;
        this.fn += evaluation.fn;
        this.fp += evaluation.fp;
    }

    public BigDecimal accuracy() {
        return new BigDecimal(this.tp + this.tn).divide(new BigDecimal(this.tp + this.tn + this.fp + this.fn), this.scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public BigDecimal geometricMean() {
        if (this.tp == 0L || this.tn == 0L) {
            return BigDecimal.ZERO;
        }
        BigDecimal tpfn = new BigDecimal(this.tp).divide(new BigDecimal(this.tp + this.fn), MathContext.DECIMAL128);
        BigDecimal tnfp = new BigDecimal(this.tn).divide(new BigDecimal(this.fp + this.tn), MathContext.DECIMAL128);
        return new BigDecimal(Math.sqrt(tpfn.multiply(tnfp).doubleValue())).setScale(this.scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public BigDecimal f1Score() {
        if (this.tp == 0L) {
            return BigDecimal.ZERO;
        }
        BigDecimal precision = new BigDecimal(this.tp).divide(new BigDecimal(this.tp + this.fp), MathContext.DECIMAL128);
        BigDecimal recall = new BigDecimal(this.tp).divide(new BigDecimal(this.tp + this.fn), this.scale, RoundingMode.HALF_UP);
        if (recall.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal up = precision.multiply(recall);
        BigDecimal down = precision.add(recall);
        return new BigDecimal(2).multiply(up).divide(down, this.scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public BigDecimal precision() {
        if (this.tp == 0L) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(this.tp).divide(new BigDecimal(this.tp + this.fp), this.scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public BigDecimal recall() {
        if (this.tp == 0L) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(this.tp).divide(new BigDecimal(this.tp + this.fn), this.scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public BigDecimal errorRate() {
        return new BigDecimal(this.fn + this.fp).divide(new BigDecimal(this.tp + this.tn + this.fp + this.fn), this.scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public long getPositive() {
        return this.tp + this.tn;
    }

    public long getNegative() {
        return this.fp + this.fn;
    }

    public long length() {
        return this.tp + this.tn + this.fp + this.fn;
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.toJsonObject());
    }

    public JsonObject toJsonObject() {
        JsonObject jsonObject = new JsonObject();
        if (this.id != null) {
            jsonObject.addProperty("id", this.id);
        }
        if (this.name != null) {
            jsonObject.addProperty("name", this.name);
        }
        if (this.length() == 0L) {
            return jsonObject;
        }
        this.setJsonObject(jsonObject);
        return jsonObject;
    }

    public void setJsonObject(JsonObject jsonObject) {
        jsonObject.addProperty("length", (Number)this.length());
        jsonObject.addProperty("accuracy", (Number)this.accuracy());
        jsonObject.addProperty("f1_score", (Number)this.f1Score());
        jsonObject.addProperty("geometric_mean", (Number)this.geometricMean());
        jsonObject.addProperty("precision", (Number)this.precision());
        jsonObject.addProperty("recall", (Number)this.recall());
        jsonObject.addProperty("p", (Number)this.getPositive());
        jsonObject.addProperty("n", (Number)this.getNegative());
        jsonObject.addProperty("tp", (Number)this.tp);
        jsonObject.addProperty("tn", (Number)this.tn);
        jsonObject.addProperty("fn", (Number)this.fn);
        jsonObject.addProperty("fp", (Number)this.fp);
    }
}

