/*
 * Decompiled with CFR 0.152.
 */
package io.runon.classification.evaluation;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.runon.classification.evaluation.ClassificationEvaluation;
import io.runon.classification.evaluation.MultinomialEvaluation;

public class TradingTestEvaluation
extends MultinomialEvaluation {
    private final MultinomialEvaluation tradingEvaluation;
    private final MultinomialEvaluation testEvaluation;

    public TradingTestEvaluation(ClassificationEvaluation[] evaluations) {
        super(evaluations);
        this.tradingEvaluation = new MultinomialEvaluation(this.copy(evaluations));
        this.testEvaluation = new MultinomialEvaluation(this.copy(evaluations));
    }

    @Override
    public void setScale(int scale) {
        super.setScale(scale);
        this.tradingEvaluation.setScale(scale);
        this.testEvaluation.setScale(scale);
    }

    @Override
    public void setId(String id) {
        this.id = id;
        this.tradingEvaluation.setId(id);
        this.testEvaluation.setId(id);
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.tradingEvaluation.setName(name);
        this.testEvaluation.setName(name);
    }

    private ClassificationEvaluation[] copy(ClassificationEvaluation[] evaluations) {
        ClassificationEvaluation[] copy = new ClassificationEvaluation[evaluations.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = new ClassificationEvaluation();
            copy[i].setId(evaluations[i].getId());
            copy[i].setName(evaluations[i].getName());
        }
        return copy;
    }

    public void add(boolean isTrading, String classificationId, String trueId) {
        this.add(classificationId, trueId);
        if (isTrading) {
            this.tradingEvaluation.add(classificationId, trueId);
        } else {
            this.testEvaluation.add(classificationId, trueId);
        }
    }

    public MultinomialEvaluation getTradingEvaluation() {
        return this.tradingEvaluation;
    }

    public MultinomialEvaluation getTestEvaluation() {
        return this.testEvaluation;
    }

    @Override
    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.toJsonObject());
    }

    @Override
    public JsonObject toJsonObject() {
        JsonObject jsonObject = new JsonObject();
        if (this.id != null) {
            jsonObject.addProperty("id", this.id);
        }
        if (this.name != null) {
            jsonObject.addProperty("name", this.name);
        }
        if (this.length() == 0L) {
            return jsonObject;
        }
        if (this.tradingEvaluation.length() == 0L && this.testEvaluation.length() == 0L) {
            return jsonObject;
        }
        if (this.testEvaluation.length() == 0L) {
            return this.tradingEvaluation.toJsonObject();
        }
        if (this.tradingEvaluation.length() == 0L) {
            return this.testEvaluation.toJsonObject();
        }
        JsonObject total = new JsonObject();
        this.setJsonObject(total);
        jsonObject.add("total", (JsonElement)total);
        JsonObject trading = new JsonObject();
        this.tradingEvaluation.setJsonObject(trading);
        jsonObject.add("trading", (JsonElement)trading);
        JsonObject test = new JsonObject();
        this.testEvaluation.setJsonObject(test);
        jsonObject.add("test", (JsonElement)test);
        JsonArray array = new JsonArray();
        for (int i = 0; i < this.evaluations.length; ++i) {
            JsonObject evaluation = new JsonObject();
            JsonObject totalJson = new JsonObject();
            if (this.evaluations[i].length() == 0L) continue;
            this.evaluations[i].setJsonObject(totalJson);
            evaluation.add("total", (JsonElement)totalJson);
            if (this.tradingEvaluation.evaluations[i].length() > 0L) {
                JsonObject tradingJson = new JsonObject();
                this.tradingEvaluation.evaluations[i].setJsonObject(tradingJson);
                evaluation.add("trading", (JsonElement)tradingJson);
            }
            if (this.testEvaluation.evaluations[i].length() > 0L) {
                JsonObject testJson = new JsonObject();
                this.testEvaluation.evaluations[i].setJsonObject(testJson);
                evaluation.add("test", (JsonElement)testJson);
            }
            array.add((JsonElement)evaluation);
        }
        jsonObject.add("evaluations", (JsonElement)array);
        return jsonObject;
    }
}

