/*
 * Decompiled with CFR 0.152.
 */
package io.runon.classification.evaluation;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.runon.classification.evaluation.ClassificationEvaluation;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class MultinomialEvaluation {
    String id;
    String name;
    int scale = 4;
    long p = 0L;
    long n = 0L;
    ClassificationEvaluation[] evaluations;

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
        for (ClassificationEvaluation evaluation : this.evaluations) {
            evaluation.setScale(scale);
        }
    }

    public MultinomialEvaluation(ClassificationEvaluation[] evaluations) {
        this.evaluations = evaluations;
    }

    public ClassificationEvaluation[] getEvaluations() {
        return this.evaluations;
    }

    public void add(String classificationId, String trueId) {
        if (classificationId.equals(trueId)) {
            ++this.p;
            for (ClassificationEvaluation evaluation : this.evaluations) {
                if (evaluation.getId().equals(trueId)) {
                    evaluation.addTruePositive();
                    continue;
                }
                evaluation.addTrueNegative();
            }
        } else {
            ++this.n;
            for (ClassificationEvaluation evaluation : this.evaluations) {
                if (evaluation.getId().equals(trueId)) {
                    evaluation.addFalseNegative();
                    continue;
                }
                if (evaluation.getId().equals(classificationId)) {
                    evaluation.addFalsePositive();
                    continue;
                }
                evaluation.addTrueNegative();
            }
        }
    }

    public long length() {
        return this.p + this.n;
    }

    public long getPositive() {
        return this.p;
    }

    public long getNegative() {
        return this.n;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal accuracy() {
        int count = 0;
        BigDecimal sum = BigDecimal.ZERO;
        for (ClassificationEvaluation evaluation : this.evaluations) {
            if (evaluation.length() == 0L) continue;
            ++count;
            sum = sum.add(evaluation.accuracy());
        }
        return sum.divide(new BigDecimal(count), this.scale, RoundingMode.HALF_UP);
    }

    public BigDecimal f1Score() {
        int count = 0;
        BigDecimal precisionSum = BigDecimal.ZERO;
        BigDecimal recallSum = BigDecimal.ZERO;
        for (ClassificationEvaluation evaluation : this.evaluations) {
            if (evaluation.length() == 0L) continue;
            ++count;
            if (evaluation.tp == 0L) continue;
            precisionSum = precisionSum.add(new BigDecimal(evaluation.tp).divide(new BigDecimal(evaluation.tp + evaluation.fp), MathContext.DECIMAL128));
            recallSum = recallSum.add(new BigDecimal(evaluation.tp).divide(new BigDecimal(evaluation.tp + evaluation.fn), MathContext.DECIMAL128));
        }
        if (recallSum.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal length = new BigDecimal(count);
        BigDecimal precision = precisionSum.divide(length, MathContext.DECIMAL128);
        BigDecimal recall = recallSum.divide(length, MathContext.DECIMAL128);
        BigDecimal up = precision.multiply(recall);
        BigDecimal down = precision.add(recall);
        return new BigDecimal(2).multiply(up).divide(down, this.scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public BigDecimal geometricMean() {
        int count = 0;
        BigDecimal sum = BigDecimal.ZERO;
        for (ClassificationEvaluation evaluation : this.evaluations) {
            if (evaluation.length() == 0L) continue;
            ++count;
            sum = sum.add(evaluation.geometricMean());
        }
        return sum.divide(new BigDecimal(count), this.scale, RoundingMode.HALF_UP);
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.toJsonObject());
    }

    public JsonObject toJsonObject() {
        JsonObject jsonObject = new JsonObject();
        if (this.id != null) {
            jsonObject.addProperty("id", this.id);
        }
        if (this.name != null) {
            jsonObject.addProperty("name", this.name);
        }
        if (this.length() == 0L) {
            return jsonObject;
        }
        this.setJsonObject(jsonObject);
        JsonArray array = new JsonArray();
        for (ClassificationEvaluation evaluation : this.evaluations) {
            if (evaluation.length() <= 0L) continue;
            array.add((JsonElement)evaluation.toJsonObject());
        }
        jsonObject.add("evaluations", (JsonElement)array);
        return jsonObject;
    }

    public void setJsonObject(JsonObject jsonObject) {
        jsonObject.addProperty("length", (Number)this.length());
        jsonObject.addProperty("simple_accuracy", (Number)new BigDecimal(this.getPositive()).divide(new BigDecimal(this.length()), this.scale, RoundingMode.HALF_UP).stripTrailingZeros());
        jsonObject.addProperty("accuracy", (Number)this.accuracy());
        jsonObject.addProperty("f1_score", (Number)this.f1Score());
        jsonObject.addProperty("geometric_mean", (Number)this.geometricMean());
        jsonObject.addProperty("p", (Number)this.getPositive());
        jsonObject.addProperty("n", (Number)this.getNegative());
    }
}

