/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.identities;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.rtr.alchemy.identities.Attributes;
import io.rtr.alchemy.identities.AttributesMap;
import io.rtr.alchemy.identities.IdentityBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public abstract class Identity {
    protected static final Set<String> EMPTY = Collections.emptySet();
    private static final LoadingCache<Class<?>, Set<String>> ATTRIBUTES_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Set<String>>(){

        public Set<String> load(@Nonnull Class<?> clazz) throws Exception {
            Attributes annotation = clazz.getAnnotation(Attributes.class);
            if (annotation == null) {
                return EMPTY;
            }
            HashSet<String> result = new HashSet<String>();
            Collections.addAll(result, annotation.value());
            for (Class<? extends Identity> identity : annotation.identities()) {
                result.addAll((Collection)ATTRIBUTES_CACHE.get(identity));
            }
            return result;
        }
    });

    public static <T extends Identity> Set<String> getSupportedAttributes(Class<T> clazz) {
        try {
            return (Set)ATTRIBUTES_CACHE.get(clazz);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public long computeHash(int seed, Set<String> hashAttributes, AttributesMap attributes) {
        IdentityBuilder builder = IdentityBuilder.seed(seed);
        Set<String> names = hashAttributes.isEmpty() ? attributes.keySet() : hashAttributes;
        for (String name : names) {
            Class<?> type = attributes.getType(name);
            if (type == String.class) {
                builder.putString(attributes.getString(name));
                continue;
            }
            if (type == Long.class) {
                builder.putLong(attributes.getNumber(name));
                continue;
            }
            if (type != Boolean.class) continue;
            builder.putBoolean(attributes.getBoolean(name));
        }
        return builder.hash();
    }

    public abstract AttributesMap computeAttributes();

    protected IdentityBuilder identity(int seed) {
        return IdentityBuilder.seed(seed);
    }

    protected AttributesMap.Builder attributes() {
        return AttributesMap.newBuilder();
    }
}

