/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.models;

import io.rtr.alchemy.filtering.FilterExpression;
import io.rtr.alchemy.identities.AttributesMap;
import io.rtr.alchemy.identities.Identity;
import io.rtr.alchemy.identities.IdentityBuilder;
import io.rtr.alchemy.models.Allocation;
import io.rtr.alchemy.models.Allocations;
import io.rtr.alchemy.models.Experiments;
import io.rtr.alchemy.models.Named;
import io.rtr.alchemy.models.Treatment;
import io.rtr.alchemy.models.TreatmentOverride;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.validation.ValidationException;
import org.apache.commons.math3.util.FastMath;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Experiment
implements Named {
    private static final Set<String> EMPTY_SET = new HashSet<String>();
    private static final Function<TreatmentOverride, String> TREATMENT_INDEXER = new Function<TreatmentOverride, String>(){

        @Override
        @Nullable
        public String apply(@Nullable TreatmentOverride input) {
            return Optional.ofNullable(input).map(TreatmentOverride::getName).orElse(null);
        }
    };
    private final Experiments owner;
    private final String name;
    private final Allocations allocations;
    private final Map<String, Treatment> treatments;
    private final Map<String, TreatmentOverride> overrides;
    private int seed;
    private String description;
    private FilterExpression filter;
    private Set<String> hashAttributes;
    private boolean active;
    private DateTime created;
    private DateTime modified;
    private DateTime activated;
    private DateTime deactivated;

    private Experiment(Experiments owner, String name, int seed, String description, FilterExpression filter, Set<String> hashAttributes, boolean active, DateTime created, DateTime modified, DateTime activated, DateTime deactivated, Map<String, Treatment> treatments, Iterable<TreatmentOverride> overrides, Iterable<Allocation> allocations) {
        this.owner = owner;
        this.name = name;
        this.description = description;
        this.filter = Optional.ofNullable(filter).orElse(FilterExpression.alwaysTrue());
        this.hashAttributes = Optional.ofNullable(hashAttributes).orElse(EMPTY_SET);
        this.active = active;
        this.created = created;
        this.modified = modified;
        this.activated = activated;
        this.deactivated = deactivated;
        this.treatments = new ConcurrentHashMap<String, Treatment>(treatments);
        this.overrides = StreamSupport.stream(overrides.spliterator(), false).collect(Collectors.toConcurrentMap(TREATMENT_INDEXER, Function.identity()));
        this.allocations = new Allocations(allocations);
        this.seed = seed;
    }

    protected Experiment(Experiments owner, String name) {
        this.owner = owner;
        this.name = name;
        this.filter = FilterExpression.alwaysTrue();
        this.hashAttributes = EMPTY_SET;
        this.allocations = new Allocations();
        this.treatments = new ConcurrentHashMap<String, Treatment>();
        this.overrides = new ConcurrentHashMap<String, TreatmentOverride>();
        this.seed = (int)IdentityBuilder.seed(0).putString(name).hash();
    }

    private Experiment(Experiment toCopy) throws ValidationException {
        Treatment treatment;
        this.owner = toCopy.owner;
        this.name = toCopy.name;
        this.treatments = new ConcurrentHashMap<String, Treatment>();
        for (Treatment treatment2 : toCopy.getTreatments()) {
            this.treatments.put(treatment2.getName(), new Treatment(treatment2.getName(), treatment2.getDescription()));
        }
        ArrayList<Allocation> allocations = new ArrayList<Allocation>();
        for (Allocation allocation : toCopy.getAllocations()) {
            treatment = this.treatments.get(allocation.getTreatment().getName());
            allocations.add(new Allocation(treatment, allocation.getOffset(), allocation.getSize()));
        }
        this.allocations = new Allocations(allocations);
        this.overrides = new ConcurrentHashMap<String, TreatmentOverride>();
        for (TreatmentOverride override : toCopy.getOverrides()) {
            treatment = this.treatments.get(override.getTreatment().getName());
            TreatmentOverride newOverride = new TreatmentOverride(override.getName(), override.getFilter(), treatment);
            this.overrides.put(override.getName(), newOverride);
        }
        this.seed = toCopy.seed;
        this.description = toCopy.description;
        this.filter = toCopy.filter;
        this.hashAttributes = new LinkedHashSet<String>(toCopy.getHashAttributes());
        this.active = toCopy.active;
        this.created = toCopy.created;
        this.modified = toCopy.modified;
        this.activated = toCopy.activated;
        this.deactivated = toCopy.deactivated;
    }

    public static Experiment copyOf(Experiment experiment) throws ValidationException {
        return experiment != null ? new Experiment(experiment) : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Experiment setDescription(String description) {
        this.description = description;
        return this;
    }

    public FilterExpression getFilter() {
        return this.filter;
    }

    public Experiment setFilter(FilterExpression filter) {
        this.filter = filter;
        return this;
    }

    public Set<String> getHashAttributes() {
        return Collections.unmodifiableSet(this.hashAttributes);
    }

    public Experiment setHashAttributes(Set<String> hashAttributes) {
        this.hashAttributes = hashAttributes == null ? EMPTY_SET : new LinkedHashSet<String>(hashAttributes);
        return this;
    }

    public Experiment setHashAttributes(String ... hashAttributes) {
        this.hashAttributes = hashAttributes == null ? EMPTY_SET : new LinkedHashSet<String>(List.of(hashAttributes));
        return this;
    }

    public int getSeed() {
        return this.seed;
    }

    public Experiment setSeed(int seed) {
        this.seed = seed;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public DateTime getModified() {
        return this.modified;
    }

    public DateTime getActivated() {
        return this.activated;
    }

    public DateTime getDeactivated() {
        return this.deactivated;
    }

    public List<Allocation> getAllocations() {
        return Collections.unmodifiableList(this.allocations.getAllocations());
    }

    public List<Treatment> getTreatments() {
        return List.copyOf(this.treatments.values());
    }

    public Treatment getTreatment(String treatmentName) {
        return this.treatments.get(treatmentName);
    }

    public List<TreatmentOverride> getOverrides() {
        return List.copyOf(this.overrides.values());
    }

    public TreatmentOverride getOverride(String overrideName) {
        return this.overrides.get(overrideName);
    }

    public Experiment activate() {
        if (this.active) {
            return this;
        }
        this.active = true;
        this.activated = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        return this;
    }

    public Experiment deactivate() {
        if (!this.active) {
            return this;
        }
        this.active = false;
        this.deactivated = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        return this;
    }

    public Experiment addTreatment(String name) throws ValidationException {
        this.treatments.put(name, new Treatment(name));
        return this;
    }

    public Experiment addTreatment(String name, String description) throws ValidationException {
        this.treatments.put(name, new Treatment(name, description));
        return this;
    }

    public Experiment clearTreatments() {
        List<Treatment> toRemove = List.copyOf(this.treatments.values());
        for (Treatment treatment : toRemove) {
            this.removeTreatment(treatment.getName());
        }
        return this;
    }

    public Experiment clearOverrides() {
        this.overrides.clear();
        return this;
    }

    public Experiment addOverride(String overrideName, String treatmentName, String filter) throws ValidationException {
        FilterExpression filterExp = FilterExpression.of(filter);
        TreatmentOverride override = new TreatmentOverride(overrideName, filterExp, this.treatment(treatmentName));
        this.overrides.put(overrideName, override);
        return this;
    }

    public Experiment removeOverride(String overrideName) {
        this.overrides.remove(overrideName);
        return this;
    }

    public Experiment removeOverrides(String treatmentName) {
        Treatment treatment = this.treatments.get(treatmentName);
        if (treatment == null) {
            return this;
        }
        this.overrides.entrySet().removeIf(entry -> ((TreatmentOverride)entry.getValue()).getTreatment().equals(treatment));
        return this;
    }

    public Experiment removeTreatment(String name) {
        Treatment treatment = this.treatments.get(name);
        if (treatment == null) {
            return this;
        }
        this.removeOverrides(name);
        this.allocations.deallocate(treatment, 100);
        this.treatments.remove(name);
        return this;
    }

    private Treatment treatment(String name) {
        Treatment treatment = this.treatments.get(name);
        if (treatment == null) {
            throw new IllegalArgumentException(String.format("no treatment with name %s defined", name));
        }
        return treatment;
    }

    public Experiment save() {
        this.modified = this.created == null ? (this.created = DateTime.now((DateTimeZone)DateTimeZone.UTC)) : DateTime.now((DateTimeZone)DateTimeZone.UTC);
        this.owner.save(this);
        return this;
    }

    public void delete() {
        this.owner.delete(this.name);
    }

    public Experiment allocate(String treatmentName, int size) {
        this.allocations.allocate(this.treatment(treatmentName), size);
        return this;
    }

    public Experiment deallocate(String treatmentName, int size) {
        this.allocations.deallocate(this.treatment(treatmentName), size);
        return this;
    }

    public Experiment reallocate(String sourceTreatmentName, String destinationTreatmentName, int size) {
        this.allocations.reallocate(this.treatment(sourceTreatmentName), this.treatment(destinationTreatmentName), size);
        return this;
    }

    public Experiment deallocateAll() {
        this.allocations.clear();
        return this;
    }

    private int identityToBin(Identity identity, AttributesMap attributes) {
        return (int)(FastMath.abs((long)identity.computeHash(this.seed, this.hashAttributes, attributes)) % 100L);
    }

    public Treatment getTreatment(Identity identity, AttributesMap attributes) {
        return this.allocations.getTreatment(this.identityToBin(identity, attributes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Experiment)) {
            return false;
        }
        Experiment that = (Experiment)o;
        return Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public String toString() {
        return new StringJoiner(", ", Experiment.class.getSimpleName() + "[", "]").add("owner=" + String.valueOf(this.owner)).add("name='" + this.name + "'").add("allocations=" + String.valueOf(this.allocations)).add("treatments=" + String.valueOf(this.treatments)).add("overrides=" + String.valueOf(this.overrides)).add("seed=" + this.seed).add("description='" + this.description + "'").add("filter=" + String.valueOf(this.filter)).add("hashAttributes=" + String.valueOf(this.hashAttributes)).add("active=" + this.active).add("created=" + String.valueOf(this.created)).add("modified=" + String.valueOf(this.modified)).add("activated=" + String.valueOf(this.activated)).add("deactivated=" + String.valueOf(this.deactivated)).toString();
    }

    public static class Builder {
        private final Experiments owner;
        private final String name;
        private final Map<String, Treatment> treatments;
        private final List<TreatmentOverride> overrides;
        private final List<Allocation> allocations;
        private int seed;
        private String description;
        private FilterExpression filter;
        private Set<String> hashAttributes;
        private boolean active;
        private DateTime created = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        private DateTime modified = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        private DateTime activated;
        private DateTime deactivated;

        Builder(Experiments owner, String name) {
            this.owner = owner;
            this.name = name;
            this.treatments = new HashMap<String, Treatment>();
            this.overrides = new ArrayList<TreatmentOverride>();
            this.allocations = new ArrayList<Allocation>();
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = FilterExpression.of(filter);
            return this;
        }

        public Builder hashAttributes(String ... hashAttributes) {
            this.hashAttributes = new LinkedHashSet<String>(Arrays.asList(hashAttributes));
            return this;
        }

        public Builder hashAttributes(Set<String> hashAttributes) {
            this.hashAttributes = new LinkedHashSet<String>(hashAttributes);
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder modified(DateTime modified) {
            this.modified = modified;
            return this;
        }

        public Builder activated(DateTime activated) {
            this.activated = activated;
            return this;
        }

        public Builder deactivated(DateTime deactivated) {
            this.deactivated = deactivated;
            return this;
        }

        public Builder seed(int seed) {
            this.seed = seed;
            return this;
        }

        private Treatment getTreatment(String name) {
            Treatment treatment = this.treatments.get(name);
            if (treatment == null) {
                throw new IllegalArgumentException(String.format("treatment with name %s must be defined first", name));
            }
            return treatment;
        }

        public Builder addTreatment(String name, String description) throws ValidationException {
            this.treatments.put(name, new Treatment(name, description));
            return this;
        }

        public Builder addOverride(String name, String filter, String treatmentName) throws ValidationException {
            this.overrides.add(new TreatmentOverride(name, FilterExpression.of(filter), this.getTreatment(treatmentName)));
            return this;
        }

        public Builder addAllocation(String treatmentName, int offset, int size) {
            this.allocations.add(new Allocation(this.getTreatment(treatmentName), offset, size));
            return this;
        }

        public Experiment build() {
            return new Experiment(this.owner, this.name, this.seed, this.description, this.filter, this.hashAttributes, this.active, this.created, this.modified, this.activated, this.deactivated, this.treatments, this.overrides, this.allocations);
        }
    }

    public static class BuilderFactory {
        private final Experiments owner;

        BuilderFactory(Experiments owner) {
            this.owner = owner;
        }

        public Builder createBuilder(String experimentName) {
            return new Builder(this.owner, experimentName);
        }
    }
}

