/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.models;

import io.rtr.alchemy.models.Allocation;
import io.rtr.alchemy.models.Treatment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Allocations {
    public static final int NUM_BINS = 100;
    private static final Comparator<Allocation> COMPARATOR = Comparator.comparingInt(Allocation::getOffset);
    private Byte[] allocationMap;
    private List<Allocation> allocations;
    private Treatment[] treatmentsMap;
    private int size;

    public Allocations() {
        this(new ArrayList<Allocation>());
    }

    public Allocations(Iterable<Allocation> allocations) {
        this.allocations = StreamSupport.stream(allocations.spliterator(), false).collect(Collectors.toList());
        this.sortAllocations();
        this.rebuildAllocationTables();
    }

    private void sortAllocations() {
        this.allocations.sort(COMPARATOR);
    }

    private void rebuildAllocationTables() {
        HashMap<Treatment, Integer> treatments = new HashMap<Treatment, Integer>();
        int size = 0;
        this.allocationMap = new Byte[100];
        for (Allocation allocation : this.allocations) {
            Integer treatment = treatments.computeIfAbsent(allocation.getTreatment(), k -> treatments.size());
            int i = allocation.getOffset();
            while (i < allocation.getOffset() + allocation.getSize()) {
                if (this.allocationMap[i] != null) {
                    throw new IllegalStateException("overlapping allocations");
                }
                this.allocationMap[i] = treatment.byteValue();
                ++i;
                ++size;
            }
        }
        this.size = size;
        this.treatmentsMap = new Treatment[treatments.size()];
        for (Map.Entry entry : treatments.entrySet()) {
            this.treatmentsMap[((Integer)entry.getValue()).intValue()] = (Treatment)entry.getKey();
        }
    }

    public Treatment getTreatment(int bin) {
        Byte treatmentIndex = this.allocationMap[bin];
        if (treatmentIndex == null) {
            return null;
        }
        return this.treatmentsMap[treatmentIndex];
    }

    private void mergeAdjacentAllocations() {
        if (this.allocations.size() < 2) {
            return;
        }
        ArrayList<Allocation> newList = new ArrayList<Allocation>();
        int totalSize = this.allocations.get(0).getSize();
        int offset = this.allocations.get(0).getOffset();
        Treatment treatment = this.allocations.get(0).getTreatment();
        for (int i = 1; i < this.allocations.size(); ++i) {
            Allocation allocation = this.allocations.get(i);
            if (!allocation.getTreatment().equals(treatment)) {
                newList.add(new Allocation(treatment, offset, totalSize));
                totalSize = allocation.getSize();
                offset = allocation.getOffset();
                treatment = allocation.getTreatment();
                continue;
            }
            totalSize += allocation.getSize();
        }
        newList.add(new Allocation(treatment, offset, totalSize));
        this.allocations = newList;
    }

    public void allocate(Treatment treatment, int size) {
        if (this.getUnallocatedSize() < size) {
            throw new IllegalArgumentException(String.format("not enough free bins to allocate treatment %s with size %s given %s unallocated bin(s)", treatment.getName(), size, this.getUnallocatedSize()));
        }
        ArrayList<Allocation> pieces = new ArrayList<Allocation>();
        int sizeLeft = size;
        int offset = 0;
        int index = 0;
        while (sizeLeft > 0) {
            if (index < this.allocations.size()) {
                Allocation allocation = this.allocations.get(index);
                int pieceSize = allocation.getOffset() - offset;
                if (pieceSize > 0) {
                    sizeLeft -= pieceSize;
                    pieces.add(new Allocation(treatment, offset, pieceSize));
                }
                offset = allocation.getOffset() + allocation.getSize();
                ++index;
                continue;
            }
            pieces.add(new Allocation(treatment, offset, sizeLeft));
            sizeLeft = 0;
        }
        this.allocations.addAll(pieces);
        this.sortAllocations();
        this.mergeAdjacentAllocations();
        this.rebuildAllocationTables();
    }

    public void deallocate(Treatment treatment, int size) {
        Iterator<Allocation> iter = this.allocations.iterator();
        int sizeLeft = size;
        while (iter.hasNext()) {
            Allocation next = iter.next();
            if (next.getTreatment().equals(treatment)) {
                sizeLeft -= next.getSize();
                iter.remove();
            }
            if (sizeLeft >= 0) continue;
            this.allocations.add(new Allocation(treatment, next.getOffset() + next.getSize() + sizeLeft, -sizeLeft));
            break;
        }
        this.sortAllocations();
        this.mergeAdjacentAllocations();
        this.rebuildAllocationTables();
    }

    public void reallocate(Treatment source, Treatment destination, int size) {
        Iterator<Allocation> iter = this.allocations.iterator();
        ArrayList<Allocation> pieces = new ArrayList<Allocation>();
        int sizeLeft = size;
        int lastOffset = 0;
        while (iter.hasNext() && sizeLeft > 0) {
            Allocation next = iter.next();
            lastOffset = next.getOffset() + next.getSize();
            if (!next.getTreatment().equals(source)) continue;
            iter.remove();
            if ((sizeLeft -= next.getSize()) < 0) {
                pieces.add(new Allocation(destination, next.getOffset(), next.getSize() + sizeLeft));
                pieces.add(new Allocation(source, next.getOffset() + next.getSize() + sizeLeft, -sizeLeft));
                continue;
            }
            pieces.add(new Allocation(destination, next.getOffset(), next.getSize()));
        }
        if (sizeLeft > 0) {
            pieces.add(new Allocation(destination, lastOffset, sizeLeft));
        }
        this.allocations.addAll(pieces);
        this.sortAllocations();
        this.mergeAdjacentAllocations();
        this.rebuildAllocationTables();
    }

    public List<Allocation> getAllocations() {
        return List.copyOf(this.allocations);
    }

    public int getSize() {
        return this.size;
    }

    public int getUnallocatedSize() {
        return 100 - this.size;
    }

    public void clear() {
        this.allocations.clear();
        this.rebuildAllocationTables();
    }
}

