/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.identities;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;

public class IdentityBuilder {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final Hasher hasher;

    private IdentityBuilder(int seed) {
        this.hasher = Hashing.murmur3_128((int)seed).newHasher();
    }

    public static IdentityBuilder seed(int seed) {
        return new IdentityBuilder(seed);
    }

    public IdentityBuilder putByte(Byte value) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putByte(value.byteValue());
        }
        return this;
    }

    public IdentityBuilder putBytes(byte[] value) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putBytes(value);
        }
        return this;
    }

    public IdentityBuilder putBytes(byte[] value, int start, int length) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putBytes(value, start, length);
        }
        return this;
    }

    public IdentityBuilder putShort(Short value) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putShort(value.shortValue());
        }
        return this;
    }

    public IdentityBuilder putInt(Integer value) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putInt(value.intValue());
        }
        return this;
    }

    public IdentityBuilder putLong(Long value) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putLong(value.longValue());
        }
        return this;
    }

    public IdentityBuilder putFloat(Float value) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putFloat(value.floatValue());
        }
        return this;
    }

    public IdentityBuilder putDouble(Double value) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putDouble(value.doubleValue());
        }
        return this;
    }

    public IdentityBuilder putBoolean(Boolean value) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putBoolean(value.booleanValue());
        }
        return this;
    }

    public IdentityBuilder putChar(Character value) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putChar(value.charValue());
        }
        return this;
    }

    public IdentityBuilder putString(CharSequence value) {
        if (value == null) {
            this.putNull();
        } else {
            this.hasher.putString(value, CHARSET);
        }
        return this;
    }

    public IdentityBuilder putNull() {
        this.hasher.putLong(0L);
        return this;
    }

    public long hash() {
        return this.hasher.hash().asLong();
    }
}

