/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.caching;

import io.rtr.alchemy.caching.CacheStrategy;
import io.rtr.alchemy.caching.CachingContext;
import io.rtr.alchemy.models.Experiment;
import java.util.Iterator;

public class CacheStrategyIterable
implements Iterable<Experiment> {
    private final Iterable<Experiment> iterable;
    private final CachingContext context;
    private final CacheStrategy strategy;

    public CacheStrategyIterable(Iterable<Experiment> iterable, CachingContext context, CacheStrategy strategy) {
        this.iterable = iterable;
        this.context = context;
        this.strategy = strategy;
    }

    @Override
    public Iterator<Experiment> iterator() {
        return new CacheStrategyIterator(this.iterable.iterator());
    }

    private class CacheStrategyIterator
    implements Iterator<Experiment> {
        private final Iterator<Experiment> iterator;
        private Experiment current;

        private CacheStrategyIterator(Iterator<Experiment> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Experiment next() {
            Experiment next = this.iterator.next();
            CacheStrategyIterable.this.strategy.onLoad(next, CacheStrategyIterable.this.context);
            this.current = next;
            return next;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            CacheStrategyIterable.this.strategy.onDelete(this.current.getName(), CacheStrategyIterable.this.context);
        }
    }
}

