/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.models;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.rtr.alchemy.filtering.FilterExpression;
import io.rtr.alchemy.identities.AttributesMap;
import io.rtr.alchemy.identities.Identity;
import io.rtr.alchemy.identities.IdentityBuilder;
import io.rtr.alchemy.models.Allocation;
import io.rtr.alchemy.models.Allocations;
import io.rtr.alchemy.models.Experiments;
import io.rtr.alchemy.models.Named;
import io.rtr.alchemy.models.Treatment;
import io.rtr.alchemy.models.TreatmentOverride;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.validation.ValidationException;
import org.apache.commons.math3.util.FastMath;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Experiment
implements Named {
    private static final Set<String> EMPTY_SET = Sets.newLinkedHashSet();
    private static final Function<TreatmentOverride, String> TREATMENT_INDEXER = new Function<TreatmentOverride, String>(){

        @Nullable
        public String apply(@Nullable TreatmentOverride input) {
            return input != null ? input.getName() : null;
        }
    };
    private final Experiments owner;
    private final String name;
    private final Allocations allocations;
    private final Map<String, Treatment> treatments;
    private final Map<String, TreatmentOverride> overrides;
    private int seed;
    private String description;
    private FilterExpression filter;
    private Set<String> hashAttributes;
    private boolean active;
    private DateTime created;
    private DateTime modified;
    private DateTime activated;
    private DateTime deactivated;

    private Experiment(Experiments owner, String name, int seed, String description, FilterExpression filter, Set<String> hashAttributes, boolean active, DateTime created, DateTime modified, DateTime activated, DateTime deactivated, Map<String, Treatment> treatments, Iterable<TreatmentOverride> overrides, Iterable<Allocation> allocations) {
        this.owner = owner;
        this.name = name;
        this.description = description;
        this.filter = (FilterExpression)MoreObjects.firstNonNull((Object)filter, (Object)FilterExpression.alwaysTrue());
        this.hashAttributes = (Set)MoreObjects.firstNonNull(hashAttributes, EMPTY_SET);
        this.active = active;
        this.created = created;
        this.modified = modified;
        this.activated = activated;
        this.deactivated = deactivated;
        this.treatments = new ConcurrentHashMap<String, Treatment>(treatments);
        this.overrides = new ConcurrentHashMap<String, TreatmentOverride>((Map<String, TreatmentOverride>)Maps.uniqueIndex(overrides, TREATMENT_INDEXER));
        this.allocations = new Allocations(allocations);
        this.seed = seed;
    }

    protected Experiment(Experiments owner, String name) {
        this.owner = owner;
        this.name = name;
        this.filter = FilterExpression.alwaysTrue();
        this.hashAttributes = EMPTY_SET;
        this.allocations = new Allocations();
        this.treatments = Maps.newConcurrentMap();
        this.overrides = Maps.newConcurrentMap();
        this.seed = (int)IdentityBuilder.seed(0).putString(name).hash();
    }

    public static Experiment copyOf(Experiment experiment) throws ValidationException {
        return experiment != null ? new Experiment(experiment) : null;
    }

    private Experiment(Experiment toCopy) throws ValidationException {
        Treatment treatment;
        this.owner = toCopy.owner;
        this.name = toCopy.name;
        this.treatments = Maps.newConcurrentMap();
        for (Treatment treatment2 : toCopy.getTreatments()) {
            this.treatments.put(treatment2.getName(), new Treatment(treatment2.getName(), treatment2.getDescription()));
        }
        ArrayList allocations = Lists.newArrayList();
        for (Allocation allocation : toCopy.getAllocations()) {
            treatment = this.treatments.get(allocation.getTreatment().getName());
            allocations.add(new Allocation(treatment, allocation.getOffset(), allocation.getSize()));
        }
        this.allocations = new Allocations(allocations);
        this.overrides = Maps.newConcurrentMap();
        for (TreatmentOverride override : toCopy.getOverrides()) {
            treatment = this.treatments.get(override.getTreatment().getName());
            TreatmentOverride newOverride = new TreatmentOverride(override.getName(), override.getFilter(), treatment);
            this.overrides.put(override.getName(), newOverride);
        }
        this.seed = toCopy.seed;
        this.description = toCopy.description;
        this.filter = toCopy.filter;
        this.hashAttributes = Sets.newLinkedHashSet(toCopy.getHashAttributes());
        this.active = toCopy.active;
        this.created = toCopy.created;
        this.modified = toCopy.modified;
        this.activated = toCopy.activated;
        this.deactivated = toCopy.deactivated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Experiment setDescription(String description) {
        this.description = description;
        return this;
    }

    public FilterExpression getFilter() {
        return this.filter;
    }

    public Set<String> getHashAttributes() {
        return Collections.unmodifiableSet(this.hashAttributes);
    }

    public Experiment setFilter(FilterExpression filter) {
        this.filter = filter;
        return this;
    }

    public Experiment setHashAttributes(Set<String> hashAttributes) {
        this.hashAttributes = hashAttributes == null ? EMPTY_SET : Sets.newLinkedHashSet(hashAttributes);
        return this;
    }

    public Experiment setHashAttributes(String ... hashAttributes) {
        this.hashAttributes = hashAttributes == null ? EMPTY_SET : Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])hashAttributes));
        return this;
    }

    public Experiment setSeed(int seed) {
        this.seed = seed;
        return this;
    }

    public int getSeed() {
        return this.seed;
    }

    public boolean isActive() {
        return this.active;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public DateTime getModified() {
        return this.modified;
    }

    public DateTime getActivated() {
        return this.activated;
    }

    public DateTime getDeactivated() {
        return this.deactivated;
    }

    public List<Allocation> getAllocations() {
        return Collections.unmodifiableList(this.allocations.getAllocations());
    }

    public List<Treatment> getTreatments() {
        return Collections.unmodifiableList(Lists.newArrayList(this.treatments.values()));
    }

    public Treatment getTreatment(String treatmentName) {
        return this.treatments.get(treatmentName);
    }

    public List<TreatmentOverride> getOverrides() {
        return ImmutableList.copyOf(this.overrides.values());
    }

    public TreatmentOverride getOverride(String overrideName) {
        return this.overrides.get(overrideName);
    }

    public Experiment activate() {
        if (this.active) {
            return this;
        }
        this.active = true;
        this.activated = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        return this;
    }

    public Experiment deactivate() {
        if (!this.active) {
            return this;
        }
        this.active = false;
        this.deactivated = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        return this;
    }

    public Experiment addTreatment(String name) throws ValidationException {
        this.treatments.put(name, new Treatment(name));
        return this;
    }

    public Experiment addTreatment(String name, String description) throws ValidationException {
        this.treatments.put(name, new Treatment(name, description));
        return this;
    }

    public Experiment clearTreatments() {
        ArrayList toRemove = Lists.newArrayList(this.treatments.values());
        for (Treatment treatment : toRemove) {
            this.removeTreatment(treatment.getName());
        }
        return this;
    }

    public Experiment clearOverrides() {
        this.overrides.clear();
        return this;
    }

    public Experiment addOverride(String overrideName, String treatmentName, String filter) throws ValidationException {
        FilterExpression filterExp = FilterExpression.of(filter);
        TreatmentOverride override = new TreatmentOverride(overrideName, filterExp, this.treatment(treatmentName));
        this.overrides.put(overrideName, override);
        return this;
    }

    public Experiment removeOverride(String overrideName) {
        this.overrides.remove(overrideName);
        return this;
    }

    public Experiment removeOverrides(String treatmentName) {
        Treatment treatment = this.treatments.get(treatmentName);
        if (treatment == null) {
            return this;
        }
        Iterator<Map.Entry<String, TreatmentOverride>> iterator = this.overrides.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TreatmentOverride> entry = iterator.next();
            if (!entry.getValue().getTreatment().equals(treatment)) continue;
            iterator.remove();
        }
        return this;
    }

    public Experiment removeTreatment(String name) {
        Treatment treatment = this.treatments.get(name);
        if (treatment == null) {
            return this;
        }
        this.removeOverrides(name);
        this.allocations.deallocate(treatment, 100);
        this.treatments.remove(name);
        return this;
    }

    private Treatment treatment(String name) {
        Treatment treatment = this.treatments.get(name);
        Preconditions.checkState((treatment != null ? 1 : 0) != 0, (String)"no treatment with name %s defined", (Object)name);
        return treatment;
    }

    public Experiment save() {
        this.modified = this.created == null ? (this.created = DateTime.now((DateTimeZone)DateTimeZone.UTC)) : DateTime.now((DateTimeZone)DateTimeZone.UTC);
        this.owner.save(this);
        return this;
    }

    public void delete() {
        this.owner.delete(this.name);
    }

    public Experiment allocate(String treatmentName, int size) {
        this.allocations.allocate(this.treatment(treatmentName), size);
        return this;
    }

    public Experiment deallocate(String treatmentName, int size) {
        this.allocations.deallocate(this.treatment(treatmentName), size);
        return this;
    }

    public Experiment reallocate(String sourceTreatmentName, String destinationTreatmentName, int size) {
        this.allocations.reallocate(this.treatment(sourceTreatmentName), this.treatment(destinationTreatmentName), size);
        return this;
    }

    public Experiment deallocateAll() {
        this.allocations.clear();
        return this;
    }

    private int identityToBin(Identity identity, AttributesMap attributes) {
        return (int)(FastMath.abs((long)identity.computeHash(this.seed, this.hashAttributes, attributes)) % 100L);
    }

    public Treatment getTreatment(Identity identity, AttributesMap attributes) {
        return this.allocations.getTreatment(this.identityToBin(identity, attributes));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Experiment)) {
            return false;
        }
        Experiment other = (Experiment)obj;
        return Objects.equal((Object)this.name, (Object)other.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("description", (Object)this.description).add("filter", (Object)this.filter).add("hashAttributes", this.hashAttributes).add("active", this.active).add("created", (Object)this.created).add("modified", (Object)this.modified).add("activated", (Object)this.activated).add("deactivated", (Object)this.deactivated).add("seed", this.seed).toString();
    }

    public static class Builder {
        private final Experiments owner;
        private final String name;
        private int seed;
        private String description;
        private FilterExpression filter;
        private Set<String> hashAttributes;
        private boolean active;
        private DateTime created = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        private DateTime modified = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        private DateTime activated;
        private DateTime deactivated;
        private final Map<String, Treatment> treatments;
        private final List<TreatmentOverride> overrides;
        private final List<Allocation> allocations;

        Builder(Experiments owner, String name) {
            this.owner = owner;
            this.name = name;
            this.treatments = Maps.newHashMap();
            this.overrides = Lists.newArrayList();
            this.allocations = Lists.newArrayList();
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = FilterExpression.of(filter);
            return this;
        }

        public Builder hashAttributes(String ... hashAttributes) {
            this.hashAttributes = Sets.newLinkedHashSet(Arrays.asList(hashAttributes));
            return this;
        }

        public Builder hashAttributes(Set<String> hashAttributes) {
            this.hashAttributes = Sets.newLinkedHashSet(hashAttributes);
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder modified(DateTime modified) {
            this.modified = modified;
            return this;
        }

        public Builder activated(DateTime activated) {
            this.activated = activated;
            return this;
        }

        public Builder deactivated(DateTime deactivated) {
            this.deactivated = deactivated;
            return this;
        }

        public Builder seed(int seed) {
            this.seed = seed;
            return this;
        }

        private Treatment getTreatment(String name) {
            Treatment treatment = this.treatments.get(name);
            Preconditions.checkState((treatment != null ? 1 : 0) != 0, (String)"treatment with name %s must be defined first", (Object)name);
            return treatment;
        }

        public Builder addTreatment(String name, String description) throws ValidationException {
            this.treatments.put(name, new Treatment(name, description));
            return this;
        }

        public Builder addOverride(String name, String filter, String treatmentName) throws ValidationException {
            this.overrides.add(new TreatmentOverride(name, FilterExpression.of(filter), this.getTreatment(treatmentName)));
            return this;
        }

        public Builder addAllocation(String treatmentName, int offset, int size) {
            this.allocations.add(new Allocation(this.getTreatment(treatmentName), offset, size));
            return this;
        }

        public Experiment build() {
            return new Experiment(this.owner, this.name, this.seed, this.description, this.filter, this.hashAttributes, this.active, this.created, this.modified, this.activated, this.deactivated, this.treatments, this.overrides, this.allocations);
        }
    }

    public static class BuilderFactory {
        private final Experiments owner;

        BuilderFactory(Experiments owner) {
            this.owner = owner;
        }

        public Builder createBuilder(String experimentName) {
            return new Builder(this.owner, experimentName);
        }
    }
}

