/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.models;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.rtr.alchemy.caching.BasicCacheStrategy;
import io.rtr.alchemy.caching.CacheStrategy;
import io.rtr.alchemy.caching.CacheStrategyIterable;
import io.rtr.alchemy.caching.CachingContext;
import io.rtr.alchemy.db.ExperimentsCache;
import io.rtr.alchemy.db.ExperimentsStore;
import io.rtr.alchemy.db.ExperimentsStoreProvider;
import io.rtr.alchemy.db.Filter;
import io.rtr.alchemy.identities.AttributesMap;
import io.rtr.alchemy.identities.Identity;
import io.rtr.alchemy.models.Experiment;
import io.rtr.alchemy.models.Treatment;
import io.rtr.alchemy.models.TreatmentOverride;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.validation.ValidationException;

public class Experiments
implements Closeable {
    private final ExperimentsStore store;
    private final ExperimentsCache cache;
    private final CacheStrategy strategy;
    private final CachingContext context;

    public static Builder using(ExperimentsStoreProvider provider) {
        return new Builder(provider);
    }

    private Experiments(ExperimentsStoreProvider provider, CacheStrategy strategy, ExecutorService executorService) {
        this.store = provider.getStore();
        this.cache = provider.getCache();
        Preconditions.checkNotNull((Object)this.store, (Object)"store cannot be null");
        Preconditions.checkNotNull((Object)this.cache, (Object)"cache cannot be null");
        this.strategy = strategy != null ? strategy : new BasicCacheStrategy();
        this.context = new CachingContext(this.cache, new Experiment.BuilderFactory(this), executorService);
        this.cache.invalidateAll(new Experiment.BuilderFactory(this));
    }

    private Treatment getTreatmentWithOverrides(Experiment experiment, Identity identity, AttributesMap attributes) {
        for (TreatmentOverride override : experiment.getOverrides()) {
            if (!override.getFilter().evaluate(attributes)) continue;
            return override.getTreatment();
        }
        return experiment.getTreatment(identity, attributes);
    }

    public Treatment getActiveTreatment(String experimentName, Identity identity) {
        this.strategy.onCacheRead(experimentName, this.context);
        Experiment experiment = this.cache.getActiveExperiments().get(experimentName);
        AttributesMap attributes = identity.computeAttributes().filter(Identity.getSupportedAttributes(identity.getClass()));
        if (experiment == null || !experiment.getFilter().evaluate(attributes)) {
            return null;
        }
        return this.getTreatmentWithOverrides(experiment, identity, attributes);
    }

    public Iterable<Experiment> getActiveExperiments() {
        this.strategy.onCacheRead(this.context);
        return Iterables.unmodifiableIterable(this.cache.getActiveExperiments().values());
    }

    public Map<Experiment, Treatment> getActiveTreatments(Identity identity) {
        this.strategy.onCacheRead(this.context);
        HashMap result = Maps.newHashMap();
        AttributesMap attributes = identity.computeAttributes().filter(Identity.getSupportedAttributes(identity.getClass()));
        for (Experiment experiment : this.cache.getActiveExperiments().values()) {
            Treatment treatment;
            if (!experiment.getFilter().evaluate(attributes) || (treatment = this.getTreatmentWithOverrides(experiment, identity, attributes)) == null) continue;
            result.put(experiment, treatment);
        }
        return result;
    }

    public Iterable<Experiment> find(Filter filter) {
        return Iterables.unmodifiableIterable((Iterable)new CacheStrategyIterable(this.store.find(filter, new Experiment.BuilderFactory(this)), this.context, this.strategy));
    }

    public Iterable<Experiment> find() {
        return Iterables.unmodifiableIterable(this.find(Filter.criteria().build()));
    }

    public Experiment get(String experimentName) {
        Experiment experiment = this.store.load(experimentName, new Experiment.Builder(this, experimentName));
        if (experiment != null) {
            this.strategy.onLoad(experiment, this.context);
        }
        return experiment;
    }

    public void delete(String experimentName) {
        this.store.delete(experimentName);
        this.strategy.onDelete(experimentName, this.context);
    }

    public void save(Experiment experiment) {
        this.store.save(experiment);
        this.strategy.onSave(experiment, this.context);
    }

    public Experiment create(String name) throws ValidationException {
        return new Experiment(this, name);
    }

    @Override
    public void close() throws IOException {
        this.context.close();
    }

    public static class Builder {
        private final ExperimentsStoreProvider provider;
        private CacheStrategy strategy;
        private ExecutorService executorService;

        public Builder(ExperimentsStoreProvider provider) {
            this.provider = provider;
        }

        public Builder using(CacheStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public Builder using(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Experiments build() {
            return new Experiments(this.provider, this.strategy, this.executorService);
        }
    }
}

