/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.db;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Ordering {
    private final Map<Field, Direction> fields;

    private Ordering(Map<Field, Direction> fields) {
        this.fields = Collections.unmodifiableMap(fields);
    }

    public Map<Field, Direction> getFields() {
        return this.fields;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public static Ordering parse(String ordering) {
        if (ordering == null) {
            return Ordering.empty();
        }
        StringTokenizer tokenizer = new StringTokenizer(ordering, ",");
        LinkedHashMap fields = Maps.newLinkedHashMap();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf(45);
            Direction direction = index > -1 ? Direction.DESCENDING : Direction.ASCENDING;
            Field field = Field.fromName(token.substring(index + 1));
            Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Unsupported ordering field: %s", (Object[])new Object[]{token});
            fields.put(field, direction);
        }
        return new Ordering(fields);
    }

    public static Ordering empty() {
        return new Ordering(Maps.newHashMap());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Field, Direction> ordering = Maps.newLinkedHashMap();

        public Builder orderBy(Field field) {
            this.ordering.put(field, Direction.ASCENDING);
            return this;
        }

        public Builder orderBy(Field field, Direction direction) {
            this.ordering.put(field, direction);
            return this;
        }

        public Ordering build() {
            return new Ordering(this.ordering);
        }
    }

    public static enum Field {
        NAME("name"),
        DESCRIPTION("description"),
        CREATED("created"),
        MODIFIED("modified"),
        ACTIVATED("activated"),
        DEACTIVATED("deactivated"),
        ACTIVE("active");

        private final String name;
        private static final Map<String, Field> FIELDS_BY_NAME;

        private Field(String name) {
            this.name = name;
        }

        public static Field fromName(String name) {
            return FIELDS_BY_NAME.get(name);
        }

        public String getName() {
            return this.name;
        }

        static {
            FIELDS_BY_NAME = Maps.newHashMap();
            for (Field field : Field.values()) {
                FIELDS_BY_NAME.put(field.name, field);
            }
        }
    }

    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

