/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.db;

import com.google.common.base.Objects;
import io.rtr.alchemy.db.Ordering;

public class Filter {
    public static final Filter NONE = Filter.criteria().build();
    private final String filter;
    private final Integer offset;
    private final Integer limit;
    private final Ordering ordering;

    private Filter(String filter, Integer offset, Integer limit, Ordering ordering) {
        this.filter = filter;
        this.offset = offset;
        this.limit = limit;
        this.ordering = ordering;
    }

    public static Builder criteria() {
        return new Builder();
    }

    public String getFilter() {
        return this.filter;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.filter, this.offset, this.limit});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equal((Object)this.filter, (Object)other.filter) && Objects.equal((Object)this.offset, (Object)other.offset) && Objects.equal((Object)this.limit, (Object)other.limit);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("filter", (Object)this.filter).add("offset", (Object)this.offset).add("limit", (Object)this.limit).toString();
    }

    public static class Builder {
        private String filter;
        private Integer offset;
        private Integer limit;
        private Ordering ordering;

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder ordering(Ordering ordering) {
            this.ordering = ordering;
            return this;
        }

        public Filter build() {
            return new Filter(this.filter, this.offset, this.limit, this.ordering);
        }
    }
}

