/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.caching;

import io.rtr.alchemy.caching.BasicCacheStrategy;
import io.rtr.alchemy.caching.CachingContext;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class PeriodicStaleCheckingCacheStrategy
extends BasicCacheStrategy {
    private final Duration period;
    private final AtomicBoolean lock = new AtomicBoolean(false);
    private volatile DateTime lastSync;

    public PeriodicStaleCheckingCacheStrategy(Duration period) {
        this.period = period;
        this.lastSync = DateTime.now();
    }

    @Override
    public void onCacheRead(String experimentName, CachingContext context) {
        this.invalidateAllIfStale(context);
    }

    @Override
    public void onCacheRead(CachingContext context) {
        this.invalidateAllIfStale(context);
    }

    private void invalidateAllIfStale(CachingContext context) {
        if (!this.lock.compareAndSet(false, true)) {
            return;
        }
        try {
            Duration elapsed = new Duration((ReadableInstant)this.lastSync, (ReadableInstant)DateTime.now());
            if (!elapsed.isLongerThan((ReadableDuration)this.period)) {
                return;
            }
            this.lastSync = DateTime.now();
        }
        finally {
            this.lock.set(false);
        }
        if (context.checkIfAnyStale()) {
            context.invalidateAll(true);
        }
    }
}

