/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.identities;

import com.google.common.collect.ImmutableMap;
import io.rtr.alchemy.identities.Identity;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class AttributesMap
implements Map<String, Object> {
    private static final AttributesMap EMPTY = new AttributesMap((ImmutableMap<String, Object>)ImmutableMap.of());
    private final ImmutableMap<String, Object> values;

    private AttributesMap(ImmutableMap<String, Object> values) {
        this.values = values;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static AttributesMap empty() {
        return EMPTY;
    }

    private <T> T getValue(String name, Class<?> expectedClass, Object defaultValue) {
        Object value = this.values.get((Object)name);
        if (value == null || value.getClass() != expectedClass) {
            return (T)defaultValue;
        }
        return (T)value;
    }

    public String getString(String name) {
        return (String)this.getValue(name, String.class, null);
    }

    public String getString(String name, String defaultValue) {
        return (String)this.getValue(name, String.class, defaultValue);
    }

    public Long getNumber(String name) {
        return (Long)this.getValue(name, Long.class, null);
    }

    public Long getNumber(String name, long defaultValue) {
        return (Long)this.getValue(name, Long.class, defaultValue);
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.getValue(name, Boolean.class, null);
    }

    public Boolean getBoolean(String name, boolean defaultValue) {
        return (Boolean)this.getValue(name, Boolean.class, defaultValue);
    }

    public Class<?> getType(String name) {
        Object value = this.values.get((Object)name);
        return value != null ? value.getClass() : null;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.values.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.values.containsValue(o);
    }

    @Override
    public Object get(Object o) {
        return this.values.get(o);
    }

    @Override
    public Object put(String s, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.values.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.values.entrySet();
    }

    public AttributesMap filter(Set<String> keys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            if (!keys.contains(entry.getKey())) continue;
            builder.put(entry);
        }
        return new AttributesMap((ImmutableMap<String, Object>)builder.build());
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();

        public Builder put(String name, String value) {
            if (value != null) {
                this.builder.put((Object)name, (Object)value);
            }
            return this;
        }

        public Builder put(String name, byte value) {
            this.builder.put((Object)name, (Object)value);
            return this;
        }

        public Builder put(String name, short value) {
            this.builder.put((Object)name, (Object)value);
            return this;
        }

        public Builder put(String name, int value) {
            this.builder.put((Object)name, (Object)value);
            return this;
        }

        public Builder put(String name, long value) {
            this.builder.put((Object)name, (Object)value);
            return this;
        }

        public Builder put(String name, boolean value) {
            this.builder.put((Object)name, (Object)value);
            return this;
        }

        public Builder put(Identity identity) {
            if (identity != null) {
                this.builder.putAll((Map)identity.computeAttributes().values);
            }
            return this;
        }

        public AttributesMap build() {
            return new AttributesMap(this.builder.build());
        }
    }
}

