/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.filtering;

import com.google.common.base.Objects;
import io.rtr.alchemy.filtering.FilterErrorListener;
import io.rtr.alchemy.filtering.FilterLexer;
import io.rtr.alchemy.filtering.FilterListener;
import io.rtr.alchemy.filtering.FilterParser;
import io.rtr.alchemy.identities.AttributesMap;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;

public class FilterExpression {
    private static final FilterExpression ALWAYS_TRUE = new FilterExpression();
    private static final FilterErrorListener ERROR_LISTENER = new FilterErrorListener();
    private final ParseTreeWalker walker;
    private final FilterParser.ExpContext expression;
    private final String expressionString;

    private FilterExpression(String expressionString, FilterParser parser) {
        this.expression = parser.exp();
        this.walker = new ParseTreeWalker();
        this.expressionString = expressionString;
    }

    private FilterExpression() {
        this.walker = null;
        this.expression = null;
        this.expressionString = "true";
    }

    public static FilterExpression alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static FilterExpression of(String expression) {
        if (expression.equals("true")) {
            return ALWAYS_TRUE;
        }
        ANTLRInputStream inputStream = new ANTLRInputStream(expression);
        FilterLexer lexer = new FilterLexer((CharStream)inputStream);
        lexer.getErrorListeners().clear();
        lexer.addErrorListener(ERROR_LISTENER);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        FilterParser parser = new FilterParser((TokenStream)tokenStream);
        parser.getErrorListeners().clear();
        parser.addErrorListener(ERROR_LISTENER);
        return new FilterExpression(expression, parser);
    }

    public boolean evaluate(AttributesMap attributes) {
        if (this.expression == null) {
            return true;
        }
        FilterExpressionEvaluator evaluator = new FilterExpressionEvaluator(attributes);
        this.walker.walk((ParseTreeListener)evaluator, (ParseTree)this.expression);
        return evaluator.getResult();
    }

    public String toString() {
        return this.expressionString;
    }

    public static boolean isValid(String expression) {
        try {
            FilterExpression.of(expression);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FilterExpression)) {
            return false;
        }
        FilterExpression other = (FilterExpression)obj;
        return Objects.equal((Object)this.expressionString, (Object)other.expressionString);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.expressionString});
    }

    private static class FilterExpressionEvaluator
    implements FilterListener {
        private static final Boolean OP = null;
        private final Stack<Boolean> stack = new Stack();
        private final AttributesMap attributes;

        public FilterExpressionEvaluator(AttributesMap attributes) {
            this.attributes = attributes;
        }

        public boolean getResult() {
            return this.stack.peek();
        }

        @Override
        public void enterExp(@NotNull FilterParser.ExpContext ctx) {
            this.stack.push(OP);
        }

        @Override
        public void exitExp(@NotNull FilterParser.ExpContext ctx) {
            Boolean nextValue;
            boolean accum = this.stack.pop();
            while (!this.stack.empty() && (nextValue = this.stack.pop()) != OP) {
                accum |= nextValue.booleanValue();
            }
            this.stack.push(accum);
        }

        @Override
        public void enterTerm(@NotNull FilterParser.TermContext ctx) {
            this.stack.push(OP);
        }

        @Override
        public void exitTerm(@NotNull FilterParser.TermContext ctx) {
            Boolean nextValue;
            boolean accum = this.stack.pop();
            while (!this.stack.empty() && (nextValue = this.stack.pop()) != OP) {
                accum &= nextValue.booleanValue();
            }
            this.stack.push(accum);
        }

        @Override
        public void enterFactor(@NotNull FilterParser.FactorContext ctx) {
            this.stack.push(OP);
        }

        @Override
        public void exitFactor(@NotNull FilterParser.FactorContext ctx) {
            if (ctx.value() != null) {
                this.stack.pop();
                FilterParser.ValueContext context = ctx.value();
                if (context.IDENTIFIER() != null) {
                    String name = context.getText();
                    Class<?> type = this.attributes.getType(name);
                    if (type == String.class) {
                        this.stack.push(!this.attributes.getString(name).isEmpty());
                    } else if (type == Long.class) {
                        this.stack.push(this.attributes.getNumber(name) != 0L);
                    } else if (type == Boolean.class) {
                        this.stack.push(this.attributes.getBoolean(name));
                    } else {
                        this.stack.push(false);
                    }
                } else {
                    FilterParser.ConstantContext constant = context.constant();
                    if (constant.STRING() != null) {
                        this.stack.push(constant.STRING().getText().length() > 2);
                    } else if (constant.NUMBER() != null) {
                        long value = Long.parseLong(constant.NUMBER().getText());
                        this.stack.push(value != 0L);
                    } else if (constant.BOOLEAN() != null) {
                        this.stack.push(Boolean.parseBoolean(constant.BOOLEAN().getText()));
                    } else {
                        this.stack.push(false);
                    }
                }
            } else {
                boolean value = this.stack.pop();
                this.stack.pop();
                this.stack.push(ctx.NOT() != null ? !value : value);
            }
        }

        @Override
        public void enterValue(@NotNull FilterParser.ValueContext ctx) {
        }

        @Override
        public void exitValue(@NotNull FilterParser.ValueContext ctx) {
        }

        public void visitTerminal(@NotNull TerminalNode terminalNode) {
        }

        public void visitErrorNode(@NotNull ErrorNode errorNode) {
        }

        public void enterEveryRule(@NotNull ParserRuleContext parserRuleContext) {
        }

        public void exitEveryRule(@NotNull ParserRuleContext parserRuleContext) {
        }

        @Override
        public void enterConstant(@NotNull FilterParser.ConstantContext ctx) {
        }

        @Override
        public void exitConstant(@NotNull FilterParser.ConstantContext ctx) {
        }

        @Override
        public void enterComparison(@NotNull FilterParser.ComparisonContext ctx) {
        }

        private Class<?> getType(FilterParser.ValueContext context) {
            if (context.IDENTIFIER() != null) {
                return this.attributes.getType(context.IDENTIFIER().getText());
            }
            FilterParser.ConstantContext constant = context.constant();
            if (constant.STRING() != null) {
                return String.class;
            }
            if (constant.NUMBER() != null) {
                return Long.class;
            }
            if (constant.BOOLEAN() != null) {
                return Boolean.class;
            }
            return null;
        }

        private Comparable getValue(FilterParser.ValueContext context) {
            if (context.IDENTIFIER() != null) {
                String identifier = context.IDENTIFIER().getText();
                Class<?> type = this.attributes.getType(identifier);
                if (type == String.class) {
                    return this.attributes.getString(identifier);
                }
                if (type == Long.class) {
                    return this.attributes.getNumber(identifier);
                }
                if (type == Boolean.class) {
                    return this.attributes.getBoolean(identifier);
                }
                return null;
            }
            FilterParser.ConstantContext constant = context.constant();
            if (constant.STRING() != null) {
                String value = constant.STRING().getText();
                return value.length() == 2 ? "" : value.substring(1, value.length() - 1);
            }
            if (constant.NUMBER() != null) {
                return Long.valueOf(Long.parseLong(constant.NUMBER().getText()));
            }
            if (constant.BOOLEAN() != null) {
                return Boolean.valueOf(Boolean.parseBoolean(constant.BOOLEAN().getText()));
            }
            return null;
        }

        @Override
        public void exitComparison(@NotNull FilterParser.ComparisonContext ctx) {
            FilterParser.ValueContext lhs = ctx.value(0);
            FilterParser.ValueContext rhs = ctx.value(1);
            Class<?> lhsType = this.getType(lhs);
            Class<?> rhsType = this.getType(rhs);
            String comparison = ctx.COMPARISON().getText();
            if (lhsType == null || rhsType == null || rhsType != lhsType) {
                this.stack.push(comparison.equals("!=") || comparison.equals("<>"));
                return;
            }
            Comparable lhValue = this.getValue(lhs);
            Comparable rhValue = this.getValue(rhs);
            int value = lhValue.compareTo(rhValue);
            switch (comparison) {
                case ">": {
                    this.stack.push(value > 0);
                    break;
                }
                case "<": {
                    this.stack.push(value < 0);
                    break;
                }
                case "<=": {
                    this.stack.push(value <= 0);
                    break;
                }
                case ">=": {
                    this.stack.push(value >= 0);
                    break;
                }
                case "=": {
                    this.stack.push(value == 0);
                    break;
                }
                case "<>": 
                case "!=": {
                    this.stack.push(value != 0);
                    break;
                }
                default: {
                    this.stack.push(false);
                }
            }
        }
    }
}

