/*
 * Decompiled with CFR 0.152.
 */
package io.rtr.alchemy.caching;

import com.google.common.collect.Maps;
import io.rtr.alchemy.db.ExperimentsCache;
import io.rtr.alchemy.models.Experiment;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class CachingContext
implements Closeable {
    private final ExperimentsCache cache;
    private final Experiment.BuilderFactory builderFactory;
    private final AtomicBoolean lock;
    private final ExecutorService executorService;
    private final boolean ownsExecutorService;
    private final ConcurrentMap<String, AtomicBoolean> experimentLocks;

    public CachingContext(ExperimentsCache cache, Experiment.BuilderFactory builderFactory, ExecutorService executorService) {
        this.cache = cache;
        this.builderFactory = builderFactory;
        this.executorService = executorService != null ? executorService : Executors.newSingleThreadExecutor();
        this.ownsExecutorService = executorService == null;
        this.experimentLocks = Maps.newConcurrentMap();
        this.lock = new AtomicBoolean(false);
    }

    public CachingContext(ExperimentsCache cache, Experiment.BuilderFactory builderFactory) {
        this(cache, builderFactory, null);
    }

    public void invalidateAll(boolean async) {
        if (async) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    CachingContext.this.safeInvalidateAll(CachingContext.this.builderFactory);
                }
            });
        } else {
            this.safeInvalidateAll(this.builderFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeInvalidateAll(Experiment.BuilderFactory builderFactory) {
        if (!this.lock.compareAndSet(false, true)) {
            return;
        }
        try {
            this.cache.invalidateAll(builderFactory);
        }
        finally {
            this.lock.set(false);
        }
    }

    private AtomicBoolean getExperimentLock(String experimentName) {
        AtomicBoolean newLock = new AtomicBoolean(false);
        AtomicBoolean prevLock = this.experimentLocks.putIfAbsent(experimentName, newLock);
        return prevLock != null ? prevLock : newLock;
    }

    public void invalidate(final String experimentName, boolean async) {
        if (async) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    CachingContext.this.safeInvalidate(experimentName, CachingContext.this.builderFactory.createBuilder(experimentName));
                }
            });
        } else {
            this.safeInvalidate(experimentName, this.builderFactory.createBuilder(experimentName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeInvalidate(String experimentName, Experiment.Builder builder) {
        AtomicBoolean lock = this.getExperimentLock(experimentName);
        if (!lock.compareAndSet(false, true)) {
            return;
        }
        try {
            this.cache.invalidate(experimentName, builder);
        }
        finally {
            lock.set(false);
            this.experimentLocks.remove(experimentName);
        }
    }

    public void update(Experiment experiment) {
        this.cache.update(experiment);
    }

    public void delete(String experimentName) {
        this.cache.delete(experimentName);
    }

    public boolean checkIfAnyStale() {
        return this.cache.checkIfAnyStale();
    }

    public boolean checkIfStale(String experimentName) {
        return this.cache.checkIfStale(experimentName);
    }

    @Override
    public void close() throws IOException {
        if (this.ownsExecutorService) {
            this.executorService.shutdownNow();
        }
    }
}

