/*
 * Decompiled with CFR 0.152.
 */
package io.rogue.faces.filter;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebFilter(urlPatterns={"/javax.faces.resource/*"})
public class RelativeResourceHandlingFilter
implements Filter {
    private static final String CLASS_NAME = RelativeResourceHandlingFilter.class.getName();
    private static Logger LOGGER = Logger.getLogger(CLASS_NAME);

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String referrer;
        HttpServletRequest req;
        String METHOD_NAME = "doFilter";
        boolean requestRedirected = false;
        if (request instanceof HttpServletRequest && !(req = (HttpServletRequest)request).getRequestURI().contains(".xhtml") && (referrer = req.getHeader("referer")) != null) {
            String queryParams = new URL(referrer).getQuery();
            HashMap<String, String> params = new HashMap<String, String>();
            for (String s : queryParams.split("&")) {
                String[] tmp = s.split("=");
                params.put(tmp[0], tmp.length == 2 ? tmp[1] : null);
            }
            String libraryName = (String)params.get("ln");
            if (libraryName != null) {
                String redirectURL = req.getRequestURI() + ".xhtml?ln=" + libraryName;
                LOGGER.logp(Level.FINE, CLASS_NAME, "doFilter", "Redirecting the request to: {0}", redirectURL);
                ((HttpServletResponse)response).sendRedirect(redirectURL);
                requestRedirected = true;
            }
        }
        if (!requestRedirected) {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

