/*
 * Decompiled with CFR 0.152.
 */
package io.rogue.faces.application;

import io.rogue.faces.application.WebAppResource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class AppResourceHandler
extends ResourceHandlerWrapper {
    private static final String CLASS_NAME = AppResourceHandler.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private ResourceHandler wrapped;
    private String resourcesRoot;

    public AppResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public Resource createResource(String resourceName, String libraryName) {
        Resource resource = super.createResource(resourceName, libraryName);
        return this.getWrappedResource(resource);
    }

    private Resource getWrappedResource(Resource resource) {
        String extForm;
        int idx;
        URL baseURL;
        String METHOD_NAME = "getWrappedResource";
        Object webAppResource = null;
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        this.initResourcesRoot(context);
        if (resource != null && (baseURL = resource.getURL()) != null && (idx = (extForm = baseURL.toExternalForm()).indexOf(this.resourcesRoot)) != -1) {
            try {
                extForm = extForm.substring(idx);
                URL resourceURL = context.getResource(extForm);
                if (resourceURL != null) {
                    webAppResource = new WebAppResource(extForm, resource);
                }
            }
            catch (MalformedURLException e) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "getWrappedResource", "Failed to identify resource.", e);
            }
        }
        return webAppResource != null ? webAppResource : resource;
    }

    private void initResourcesRoot(ExternalContext context) {
        if (this.resourcesRoot == null) {
            this.resourcesRoot = context.getInitParameter("javax.faces.WEBAPP_RESOURCES_DIRECTORY");
            if (this.resourcesRoot == null) {
                this.resourcesRoot = "/resources";
            }
        }
    }
}

