package io.roastedroot.sqlite4j;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import java.io.IOException;
import java.io.UncheckedIOException;
import com.dylibso.chicory.wasm.Parser;
import com.dylibso.chicory.wasm.WasmModule;
import java.io.InputStream;

public final class SQLiteModule {

    private SQLiteModule() {
    }

    public static Machine create(Instance instance) {
        return new io.roastedroot.sqlite4j.SQLiteModuleMachine(instance);
    }

    public static WasmModule load() {
        try (InputStream in = SQLiteModule.class.getResourceAsStream("SQLiteModule.meta")) {
            return Parser.parse(in);
        } catch (IOException e) {
            throw new UncheckedIOException("Failed to load AOT WASM module", e);
        }
    }
}
