/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.quickjs4j.core;

import io.roastedroot.quickjs4j.core.GuestFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Invokables {
    private final String moduleName;
    private final Map<String, GuestFunction> functions;

    private Invokables(String moduleName, Map<String, GuestFunction> functions) {
        this.moduleName = moduleName;
        this.functions = functions;
    }

    public GuestFunction byName(String name) {
        return this.functions.get(name);
    }

    public Collection<GuestFunction> functions() {
        return this.functions.values();
    }

    public String moduleName() {
        return this.moduleName;
    }

    public static Builder builder(String moduleName) {
        return new Builder(moduleName);
    }

    public static final class Builder {
        private final String moduleName;
        private List<GuestFunction> functions = new ArrayList<GuestFunction>();

        private Builder(String moduleName) {
            this.moduleName = moduleName;
        }

        public Builder add(GuestFunction fun) {
            if (this.functions.contains(fun.name())) {
                throw new IllegalArgumentException("A function with name: " + fun.name() + " is already defined in the module: " + this.moduleName);
            }
            this.functions.add(fun);
            return this;
        }

        public Builder add(GuestFunction ... functions) {
            for (GuestFunction fun : functions) {
                this.add(fun);
            }
            return this;
        }

        public Invokables build() {
            HashMap<String, GuestFunction> finalFuncs = new HashMap<String, GuestFunction>();
            for (GuestFunction func : this.functions) {
                finalFuncs.put(func.name(), func);
            }
            return new Invokables(this.moduleName, finalFuncs);
        }
    }
}

