/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.quickjs4j.core;

import com.dylibso.chicory.experimental.hostmodule.annotations.WasmModuleInterface;
import com.dylibso.chicory.runtime.ByteArrayMemory;
import com.dylibso.chicory.runtime.ImportFunction;
import com.dylibso.chicory.runtime.ImportValues;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.TrapException;
import com.dylibso.chicory.wasi.WasiOptions;
import com.dylibso.chicory.wasi.WasiPreview1;
import com.dylibso.chicory.wasm.WasmModule;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import com.dylibso.chicory.wasm.types.ValueType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.roastedroot.quickjs4j.core.Builtins;
import io.roastedroot.quickjs4j.core.Engine_ModuleExports;
import io.roastedroot.quickjs4j.core.GuestException;
import io.roastedroot.quickjs4j.core.GuestFunction;
import io.roastedroot.quickjs4j.core.HostFunction;
import io.roastedroot.quickjs4j.core.HostRef;
import io.roastedroot.quickjs4j.core.Invokables;
import io.roastedroot.quickjs4j.core.JavyPluginModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@WasmModuleInterface(value="file:///home/runner/work/quickjs4j/quickjs4j/core/../javy_quickjs4j_plugin.wasm")
public final class Engine
implements AutoCloseable {
    private static final int ALIGNMENT = 1;
    public static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    private final ByteArrayOutputStream stdout = new ByteArrayOutputStream();
    private final ByteArrayOutputStream stderr = new ByteArrayOutputStream();
    private final WasiOptions wasiOpts = WasiOptions.builder().withStdout((OutputStream)this.stdout).withStderr((OutputStream)this.stderr).build();
    private final WasiPreview1 wasi = WasiPreview1.builder().withOptions(this.wasiOpts).build();
    private final Instance instance;
    private final Engine_ModuleExports exports;
    private final Map<String, Builtins> builtins;
    private final Map<String, Invokables> invokables;
    private final ObjectMapper mapper;
    private final List<Object> javaRefs = new ArrayList<Object>();
    private final com.dylibso.chicory.runtime.HostFunction invokeFn = new com.dylibso.chicory.runtime.HostFunction("chicory", "invoke", List.of(ValueType.I32, ValueType.I32, ValueType.I32, ValueType.I32, ValueType.I32, ValueType.I32), List.of(ValueType.I32), this::invokeBuiltin);

    public static Builder builder() {
        return new Builder();
    }

    private String readJavyString(int ptr, int len) {
        byte[] bytes = this.instance.memory().readBytes(ptr, len);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeGuestFunction(String moduleName, String name, List<Object> args, String libraryCode) {
        GuestFunction guestFunction = this.invokables.get(moduleName).byName(name);
        if (guestFunction.paramTypes().size() != args.size()) {
            throw new IllegalArgumentException("Guest function should be invoked with the expected " + guestFunction.paramTypes().size() + " params, but got: " + args.size());
        }
        StringBuilder paramsStr = new StringBuilder();
        try {
            for (int i = 0; i < args.size(); ++i) {
                Class clazz;
                if (i > 0) {
                    paramsStr.append(", ");
                }
                if ((clazz = guestFunction.paramTypes().get(i)) == HostRef.class) {
                    this.javaRefs.add(args.get(i));
                    int ptr = this.javaRefs.size() - 1;
                    paramsStr.append(this.mapper.writeValueAsString((Object)ptr));
                    continue;
                }
                paramsStr.append(this.mapper.writeValueAsString(args.get(i)));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        int codePtr = 0;
        try {
            String jsCode = new String(this.jsPrelude(), StandardCharsets.UTF_8) + "\n" + libraryCode + "\n" + new String(this.jsSuffix(), StandardCharsets.UTF_8) + "\n" + moduleName + "." + guestFunction.setResultFunName() + "(" + moduleName + "." + guestFunction.name() + "(" + String.valueOf(paramsStr) + "));";
            codePtr = this.compileRaw(jsCode.getBytes(StandardCharsets.UTF_8));
            this.exec(codePtr);
        }
        finally {
            if (codePtr != 0) {
                this.free(codePtr);
            }
        }
        return this.invokables.get(moduleName).byName(name).getResult();
    }

    private long[] invokeBuiltin(Instance instance, long[] args) {
        String moduleName = this.readJavyString((int)args[0], (int)args[1]);
        String funcName = this.readJavyString((int)args[2], (int)args[3]);
        String argsString = this.readJavyString((int)args[4], (int)args[5]);
        if (!this.builtins.containsKey(moduleName)) {
            throw new IllegalArgumentException("Failed to find builtin module name " + moduleName);
        }
        if (this.builtins.get(moduleName).byName(funcName) == null) {
            throw new IllegalArgumentException("Failed to find function with name " + funcName + " in module " + moduleName);
        }
        HostFunction receiver = this.builtins.get(moduleName).byName(funcName);
        ArrayList<Object> argsList = new ArrayList<Object>();
        try {
            JsonNode tree = this.mapper.readTree(argsString);
            if (tree.size() != receiver.paramTypes().size()) {
                throw new IllegalArgumentException("Function " + receiver.name() + " has been invoked with the incorrect number of parameters needs: " + receiver.paramTypes().stream().map(Class::getCanonicalName).collect(Collectors.joining(", ")) + ", found: " + tree.size());
            }
            for (int i = 0; i < tree.size(); ++i) {
                Class clazz = receiver.paramTypes().get(i);
                JsonNode value = tree.get(i);
                if (clazz == HostRef.class) {
                    argsList.add(this.javaRefs.get(value.intValue()));
                    continue;
                }
                argsList.add(this.mapper.treeToValue((TreeNode)value, clazz));
            }
            Object res = receiver.invoke(argsList);
            Class<Integer> returnType = receiver.returnType();
            if (returnType == HostRef.class) {
                returnType = Integer.class;
                if (res instanceof HostRef) {
                    res = ((HostRef)res).pointer();
                } else {
                    this.javaRefs.add(res);
                    res = this.javaRefs.size() - 1;
                }
            }
            String returnStr = returnType == Void.class ? "null" : this.mapper.writerFor(returnType).writeValueAsString(res);
            byte[] returnBytes = returnStr.getBytes();
            int returnPtr = this.exports.canonicalAbiRealloc(0, 0, 1, returnBytes.length);
            this.exports.memory().write(returnPtr, returnBytes);
            int LEN = 8;
            int widePtr = this.exports.canonicalAbiRealloc(0, 0, 1, LEN);
            instance.memory().writeI32(widePtr, returnPtr);
            instance.memory().writeI32(widePtr + 4, returnBytes.length);
            return new long[]{widePtr};
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Engine(Map<String, Builtins> builtins, Map<String, Invokables> invokables, ObjectMapper mapper, Function<MemoryLimits, Memory> memoryFactory) {
        this.mapper = mapper;
        this.builtins = builtins;
        invokables.entrySet().stream().forEach(e -> {
            Builtins.Builder builder = Builtins.builder((String)e.getKey());
            ((Invokables)e.getValue()).functions().forEach(entry -> builder.add(entry.setResultHostFunction()));
            this.builtins.put((String)e.getKey(), builder.build());
        });
        this.invokables = invokables;
        this.instance = Instance.builder((WasmModule)JavyPluginModule.load()).withMemoryFactory(memoryFactory).withMachineFactory(JavyPluginModule::create).withImportValues(ImportValues.builder().addFunction((ImportFunction[])this.wasi.toHostFunctions()).addFunction(new ImportFunction[]{this.invokeFn}).build()).build();
        this.exports = new Engine_ModuleExports(this.instance);
        this.exports.initializeRuntime();
    }

    private byte[] jsPrelude() {
        StringBuilder preludeBuilder = new StringBuilder();
        for (Map.Entry<String, Builtins> builtin : this.builtins.entrySet()) {
            preludeBuilder.append("globalThis." + builtin.getKey() + " = {};\n");
            for (HostFunction func : this.builtins.get(builtin.getKey()).functions()) {
                preludeBuilder.append("globalThis." + builtin.getKey() + "." + func.name() + " = (...args) => { return JSON.parse(java_invoke(\"" + builtin.getKey() + "\", \"" + func.name() + "\", JSON.stringify(args))) };\n");
            }
        }
        return preludeBuilder.toString().getBytes();
    }

    private byte[] jsSuffix() {
        StringBuilder suffixBuilder = new StringBuilder();
        for (Map.Entry<String, Invokables> invokable : this.invokables.entrySet()) {
            for (GuestFunction func : this.invokables.get(invokable.getKey()).functions()) {
                suffixBuilder.append("globalThis." + invokable.getKey() + "." + func.name() + " = " + func.globalName() + ";\n");
            }
        }
        return suffixBuilder.toString().getBytes();
    }

    public int compile(String js) {
        return this.compile(js.getBytes(StandardCharsets.UTF_8));
    }

    public int compile(byte[] js) {
        byte[] prelude = this.jsPrelude();
        byte[] jsCode = new byte[prelude.length + js.length];
        System.arraycopy(prelude, 0, jsCode, 0, prelude.length);
        System.arraycopy(js, 0, jsCode, prelude.length, js.length);
        return this.compileRaw(jsCode);
    }

    public int compileRaw(byte[] js) {
        byte[] jsCode = js;
        int ptr = this.exports.canonicalAbiRealloc(0, 0, 1, jsCode.length);
        this.exports.memory().write(ptr, jsCode);
        try {
            int aggregatedCodePtr = this.exports.compileSrc(ptr, jsCode.length);
            this.exports.canonicalAbiFree(ptr, jsCode.length, 1);
            return aggregatedCodePtr;
        }
        catch (TrapException e) {
            try {
                this.stderr.flush();
                this.stdout.flush();
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to flush stdout/stderr");
            }
            throw new IllegalArgumentException("Failed to compile JS code:\n" + new String(jsCode, StandardCharsets.UTF_8) + "\nstderr: " + this.stderr.toString(StandardCharsets.UTF_8) + "\nstdout: " + this.stdout.toString(StandardCharsets.UTF_8), e);
        }
    }

    public void exec(int codePtr) {
        int ptr = this.exports.memory().readInt(codePtr);
        int codeLength = this.exports.memory().readInt(codePtr + 4);
        try {
            this.exports.invoke(ptr, codeLength, 0, 0);
        }
        catch (TrapException e) {
            try {
                this.stderr.flush();
                this.stdout.flush();
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to flush stdout/stderr");
            }
            throw new GuestException("An exception occurred during the execution.\nstderr: " + this.stderr.toString(StandardCharsets.UTF_8) + "\nstdout: " + this.stdout.toString(StandardCharsets.UTF_8));
        }
    }

    public String stdout() {
        try {
            this.stdout.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to flush stdout");
        }
        return this.stdout.toString(StandardCharsets.UTF_8);
    }

    public String stderr() {
        try {
            this.stderr.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to flush stdout");
        }
        return this.stderr.toString(StandardCharsets.UTF_8);
    }

    public void free(int codePtr) {
        int ptr = this.exports.memory().readInt(codePtr);
        int codeLength = this.exports.memory().readInt(codePtr + 4);
        this.exports.canonicalAbiFree(ptr, codeLength, 1);
    }

    public byte[] readCompiled(int codePtr) {
        int ptr = this.exports.memory().readInt(codePtr);
        int codeLength = this.exports.memory().readInt(codePtr + 4);
        return this.exports.memory().readBytes(ptr, codeLength);
    }

    public int writeCompiled(byte[] jsBytecode) {
        int ptr = this.exports.canonicalAbiRealloc(0, 0, 1, 8);
        int codePtr = this.exports.canonicalAbiRealloc(0, 0, 1, jsBytecode.length);
        this.exports.memory().write(codePtr, jsBytecode);
        this.exports.memory().writeI32(ptr, codePtr);
        this.exports.memory().writeI32(ptr + 4, jsBytecode.length);
        return ptr;
    }

    @Override
    public void close() {
        if (this.wasi != null) {
            this.wasi.close();
        }
        if (this.stdout != null) {
            try {
                this.stdout.flush();
                this.stdout.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close stdout", e);
            }
        }
        if (this.stderr != null) {
            try {
                this.stderr.flush();
                this.stderr.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close stderr", e);
            }
        }
    }

    public static final class Builder {
        private List<Builtins> builtins = new ArrayList<Builtins>();
        private List<Invokables> invokables = new ArrayList<Invokables>();
        private ObjectMapper mapper;
        private Function<MemoryLimits, Memory> memoryFactory;

        private Builder() {
        }

        public Builder addBuiltins(Builtins builtins) {
            this.builtins.add(builtins);
            return this;
        }

        public Builder addInvokables(Invokables invokables) {
            this.invokables.add(invokables);
            return this;
        }

        public Builder withObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder withMemoryFactory(Function<MemoryLimits, Memory> memoryFactory) {
            this.memoryFactory = memoryFactory;
            return this;
        }

        public Engine build() {
            if (this.mapper == null) {
                this.mapper = DEFAULT_OBJECT_MAPPER;
            }
            if (this.memoryFactory == null) {
                this.memoryFactory = ByteArrayMemory::new;
            }
            HashMap<String, Builtins> finalBuiltins = new HashMap<String, Builtins>();
            for (Builtins builtin : this.builtins) {
                finalBuiltins.put(builtin.moduleName(), builtin);
            }
            HashMap<String, Invokables> finalInvokables = new HashMap<String, Invokables>();
            for (Invokables invokable : this.invokables) {
                finalInvokables.put(invokable.moduleName(), invokable);
            }
            return new Engine(finalBuiltins, finalInvokables, this.mapper, this.memoryFactory);
        }
    }
}

