package io.roastedroot.quickjs4j.core;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import java.io.IOException;
import java.io.UncheckedIOException;
import com.dylibso.chicory.wasm.Parser;
import com.dylibso.chicory.wasm.WasmModule;
import java.io.InputStream;

public final class JavyPluginModule {

    private JavyPluginModule() {
    }

    public static Machine create(Instance instance) {
        return new io.roastedroot.quickjs4j.core.JavyPluginMachine(instance);
    }

    public static WasmModule load() {
        try (InputStream in = JavyPluginModule.class.getResourceAsStream("JavyPlugin.meta")) {
            return Parser.parse(in);
        } catch (IOException e) {
            throw new UncheckedIOException("Failed to load AOT WASM module", e);
        }
    }
}
