/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.quickjs4j.processor;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.printer.Printer;
import io.roastedroot.quickjs4j.annotations.ScriptInterface;
import io.roastedroot.quickjs4j.processor.Quickjs4jAbstractProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class ScriptInterfaceProcessor
extends Quickjs4jAbstractProcessor {
    private final Expression processorName = new StringLiteralExpr(this.getClass().getName());

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(ScriptInterface.class)) {
            this.log(Diagnostic.Kind.NOTE, "Generating ScriptInterface for " + String.valueOf(element), null);
            try {
                this.processScriptInterface((TypeElement)element);
            }
            catch (Quickjs4jAbstractProcessor.AbortProcessingException abortProcessingException) {}
        }
        return false;
    }

    private void processScriptInterface(TypeElement type) {
        this.generateBuiltins(type);
        this.generateInvokables(type);
        this.generateProxy(type);
    }

    private void generateInvokables(TypeElement type) {
        CompilationUnit cu;
        String name = type.getSimpleName().toString();
        Set<String> excludedMembers = Set.of(type.getAnnotation(ScriptInterface.class).excluded());
        PackageElement pkg = ScriptInterfaceProcessor.getPackageName(type);
        String packageName = pkg.getQualifiedName().toString();
        CompilationUnit compilationUnit = cu = pkg.isUnnamed() ? new CompilationUnit() : new CompilationUnit(packageName);
        if (!pkg.isUnnamed()) {
            cu.setPackageDeclaration(packageName);
            cu.addImport(type.getQualifiedName().toString());
        }
        cu.addImport("io.roastedroot.quickjs4j.annotations.Invokables");
        cu.addImport("io.roastedroot.quickjs4j.annotations.GuestFunction");
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)cu.addInterface(name + "_Invokables").addAnnotation("Invokables")).addSingleMemberAnnotation(Generated.class, this.processorName);
        for (Element element : this.elements().getAllMembers(type)) {
            if (element.getKind() != ElementKind.METHOD || !(element instanceof ExecutableElement) || excludedMembers.contains(element.getSimpleName().toString())) continue;
            MethodDeclaration method = (MethodDeclaration)clazz.addMethod(element.getSimpleName().toString(), new Modifier.Keyword[0]).addAnnotation("GuestFunction");
            for (VariableElement variableElement : ((ExecutableElement)element).getParameters()) {
                method.addParameter(StaticJavaParser.parseType((String)variableElement.asType().toString()), variableElement.getSimpleName().toString());
            }
            method.setType(StaticJavaParser.parseType((String)((ExecutableElement)element).getReturnType().toString()));
            List<? extends TypeMirror> thrownTypes = ((ExecutableElement)element).getThrownTypes();
            for (TypeMirror typeMirror : thrownTypes) {
                method.addThrownException((ReferenceType)StaticJavaParser.parseType((String)typeMirror.toString()).asClassOrInterfaceType());
            }
            method.removeBody();
        }
        Object prefix = pkg.isUnnamed() ? "" : packageName + ".";
        String string = (String)prefix + String.valueOf(type.getSimpleName()) + "_Invokables";
        try (Writer writer = this.filer().createSourceFile(string, type).openWriter();){
            writer.write(cu.printer((Printer)ScriptInterfaceProcessor.printer()).toString());
        }
        catch (IOException e) {
            this.log(Diagnostic.Kind.ERROR, String.format("Failed to create %s file: %s", string, e), null);
        }
    }

    private void generateBuiltins(TypeElement type) {
        CompilationUnit cu;
        Element builtinsContext = ScriptInterfaceProcessor.getContextClassFromAnnotation(ScriptInterfaceProcessor.getScriptInterfaceAnnotation(type));
        if (builtinsContext.getSimpleName().toString().equals("Void")) {
            return;
        }
        String name = type.getSimpleName().toString();
        Set<String> excludedMembers = Set.of(type.getAnnotation(ScriptInterface.class).excluded());
        PackageElement pkg = ScriptInterfaceProcessor.getPackageName(type);
        String packageName = pkg.getQualifiedName().toString();
        CompilationUnit compilationUnit = cu = pkg.isUnnamed() ? new CompilationUnit() : new CompilationUnit(packageName);
        if (!pkg.isUnnamed()) {
            cu.setPackageDeclaration(packageName);
            cu.addImport(type.getQualifiedName().toString());
        }
        cu.addImport("io.roastedroot.quickjs4j.annotations.Builtins");
        cu.addImport("io.roastedroot.quickjs4j.annotations.HostFunction");
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)cu.addClass(name + "_Builtins").addAnnotation("Builtins")).addSingleMemberAnnotation(Generated.class, this.processorName);
        clazz.addField(StaticJavaParser.parseType((String)builtinsContext.asType().toString()), "delegate", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
        ConstructorDeclaration constr = clazz.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        constr.addParameter(builtinsContext.asType().toString(), "delegate");
        constr.setBody((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), "delegate"), (Expression)new NameExpr("delegate"), AssignExpr.Operator.ASSIGN)));
        for (Element element : this.elements().getAllMembers((TypeElement)builtinsContext)) {
            if (element.getKind() != ElementKind.METHOD || !(element instanceof ExecutableElement) || excludedMembers.contains(element.getSimpleName().toString())) continue;
            MethodDeclaration method = (MethodDeclaration)clazz.addMethod(element.getSimpleName().toString(), new Modifier.Keyword[0]).addAnnotation("HostFunction");
            MethodCallExpr invokeHandle = new MethodCallExpr((Expression)new NameExpr("delegate"), element.getSimpleName().toString());
            for (VariableElement variableElement : ((ExecutableElement)element).getParameters()) {
                invokeHandle.addArgument(variableElement.getSimpleName().toString());
                method.addParameter(StaticJavaParser.parseType((String)variableElement.asType().toString()), variableElement.getSimpleName().toString());
            }
            method.setType(StaticJavaParser.parseType((String)((ExecutableElement)element).getReturnType().toString()));
            List<? extends TypeMirror> thrownTypes = ((ExecutableElement)element).getThrownTypes();
            if (thrownTypes != null && thrownTypes.size() > 0) {
                this.log(Diagnostic.Kind.ERROR, "Checked exceptions are not supported in Builtins", type);
                throw new Quickjs4jAbstractProcessor.AbortProcessingException();
            }
            if (this.extractHasReturn((ExecutableElement)element)) {
                method.setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt((Expression)invokeHandle)));
                continue;
            }
            method.setBody((BlockStmt)new BlockStmt().addStatement((Expression)invokeHandle));
        }
        Object prefix = pkg.isUnnamed() ? "" : packageName + ".";
        String string = (String)prefix + String.valueOf(type.getSimpleName()) + "_Builtins";
        try (Writer writer = this.filer().createSourceFile(string, type).openWriter();){
            writer.write(cu.printer((Printer)ScriptInterfaceProcessor.printer()).toString());
        }
        catch (IOException e) {
            this.log(Diagnostic.Kind.ERROR, String.format("Failed to create %s file: %s", string, e), null);
        }
    }

    private void generateProxy(TypeElement type) {
        CompilationUnit cu;
        Element builtinsContext = ScriptInterfaceProcessor.getContextClassFromAnnotation(ScriptInterfaceProcessor.getScriptInterfaceAnnotation(type));
        Set<String> excludedMembers = Set.of(type.getAnnotation(ScriptInterface.class).excluded());
        String name = type.getSimpleName().toString();
        PackageElement pkg = ScriptInterfaceProcessor.getPackageName(type);
        String packageName = pkg.getQualifiedName().toString();
        CompilationUnit compilationUnit = cu = pkg.isUnnamed() ? new CompilationUnit() : new CompilationUnit(packageName);
        if (!pkg.isUnnamed()) {
            cu.setPackageDeclaration(packageName);
            cu.addImport(type.getQualifiedName().toString());
        }
        cu.addImport("io.roastedroot.quickjs4j.core.Runner");
        cu.addImport("io.roastedroot.quickjs4j.core.Engine");
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)cu.addClass(name + "_Proxy").addImplementedType(type.getSimpleName().toString())).addImplementedType(AutoCloseable.class)).addSingleMemberAnnotation(Generated.class, this.processorName);
        clazz.addField("Runner", "runner", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
        clazz.addField(name + "_Invokables", "delegate", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
        ConstructorDeclaration constructor = clazz.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        constructor.addParameter("String", "script");
        constructor.addParameter(builtinsContext.asType().toString(), "ctx");
        BlockStmt constructorBody = new BlockStmt();
        MethodCallExpr engineBuilder = new MethodCallExpr((Expression)new MethodCallExpr((Expression)new MethodCallExpr((Expression)new MethodCallExpr((Expression)new NameExpr("Engine"), "builder"), "addBuiltins", NodeList.nodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr(name + "_Builtins_Builtins"), "toBuiltins", NodeList.nodeList((Node[])new Expression[]{new ObjectCreationExpr(null, StaticJavaParser.parseClassOrInterfaceType((String)(name + "_Builtins")), NodeList.nodeList((Node[])new Expression[]{new NameExpr("ctx")}))}))})), "addInvokables", NodeList.nodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr(name + "_Invokables_Invokables"), "toInvokables")})), "build");
        constructorBody.addStatement((Expression)new AssignExpr((Expression)new VariableDeclarationExpr(StaticJavaParser.parseType((String)"Engine"), "engine"), (Expression)engineBuilder, AssignExpr.Operator.ASSIGN));
        constructorBody.addStatement((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), "runner"), (Expression)new MethodCallExpr((Expression)new MethodCallExpr((Expression)new MethodCallExpr((Expression)new NameExpr("Runner"), "builder"), "withEngine", NodeList.nodeList((Node[])new Expression[]{new NameExpr("engine")})), "build"), AssignExpr.Operator.ASSIGN));
        constructorBody.addStatement((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), "delegate"), (Expression)new MethodCallExpr((Expression)new NameExpr(name + "_Invokables_Invokables"), "create", NodeList.nodeList((Node[])new Expression[]{new NameExpr("script"), new FieldAccessExpr((Expression)new ThisExpr(), "runner")})), AssignExpr.Operator.ASSIGN));
        constructor.setBody(constructorBody);
        ((MethodDeclaration)clazz.addMethod("close", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addAnnotation(Override.class)).setBody((BlockStmt)new BlockStmt().addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("runner"), "close")));
        for (Element element : this.elements().getAllMembers(type)) {
            if (element.getKind() != ElementKind.METHOD || !(element instanceof ExecutableElement) || excludedMembers.contains(element.getSimpleName().toString())) continue;
            MethodDeclaration method = (MethodDeclaration)clazz.addMethod(element.getSimpleName().toString(), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addAnnotation(Override.class);
            MethodCallExpr invokeHandle = new MethodCallExpr((Expression)new NameExpr("delegate"), element.getSimpleName().toString());
            for (VariableElement variableElement : ((ExecutableElement)element).getParameters()) {
                invokeHandle.addArgument(variableElement.getSimpleName().toString());
                method.addParameter(StaticJavaParser.parseType((String)variableElement.asType().toString()), variableElement.getSimpleName().toString());
            }
            method.setType(StaticJavaParser.parseType((String)((ExecutableElement)element).getReturnType().toString()));
            List<? extends TypeMirror> thrownTypes = ((ExecutableElement)element).getThrownTypes();
            for (TypeMirror typeMirror : thrownTypes) {
                method.addThrownException((ReferenceType)StaticJavaParser.parseType((String)typeMirror.toString()).asClassOrInterfaceType());
            }
            if (this.extractHasReturn((ExecutableElement)element)) {
                method.setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt((Expression)invokeHandle)));
                continue;
            }
            method.setBody((BlockStmt)new BlockStmt().addStatement((Expression)invokeHandle));
        }
        Object prefix = pkg.isUnnamed() ? "" : packageName + ".";
        String string = (String)prefix + String.valueOf(type.getSimpleName()) + "_Proxy";
        try (Writer writer = this.filer().createSourceFile(string, type).openWriter();){
            writer.write(cu.printer((Printer)ScriptInterfaceProcessor.printer()).toString());
        }
        catch (IOException e) {
            this.log(Diagnostic.Kind.ERROR, String.format("Failed to create %s file: %s", string, e), null);
        }
    }

    private static AnnotationMirror getScriptInterfaceAnnotation(TypeElement element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            Element annotationElement = annotationType.asElement();
            String annotationQualifiedName = ScriptInterfaceProcessor.getPackageName(annotationElement).toString() + "." + String.valueOf(annotationElement.getSimpleName());
            if (!annotationQualifiedName.equals(ScriptInterface.class.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Element getContextClassFromAnnotation(AnnotationMirror scriptInterfaceAnnotation) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = scriptInterfaceAnnotation.getElementValues();
        Set<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> entries = values.entrySet();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : entries) {
            AnnotationValue value;
            TypeMirror typeMirror;
            String name = entry.getKey().getSimpleName().toString();
            if (!name.equals("context") || (typeMirror = (TypeMirror)(value = entry.getValue()).getValue()).getKind() != TypeKind.DECLARED) continue;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement;
        }
        return null;
    }
}

