/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.quickjs4j.processor;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.printer.Printer;
import io.roastedroot.quickjs4j.annotations.GuestFunction;
import io.roastedroot.quickjs4j.annotations.HostRefParam;
import io.roastedroot.quickjs4j.annotations.Invokables;
import io.roastedroot.quickjs4j.annotations.ReturnsHostRef;
import io.roastedroot.quickjs4j.processor.Quickjs4jAbstractProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

public final class InvokablesProcessor
extends Quickjs4jAbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Invokables.class)) {
            this.log(Diagnostic.Kind.NOTE, "Generating Invokables for " + String.valueOf(element), null);
            try {
                this.processInvokables((TypeElement)element);
            }
            catch (Quickjs4jAbstractProcessor.AbortProcessingException abortProcessingException) {}
        }
        return false;
    }

    private void processInvokables(TypeElement type) {
        CompilationUnit cu;
        String moduleName = type.getAnnotation(Invokables.class).value();
        if (moduleName.isEmpty()) {
            moduleName = type.getSimpleName().toString();
        }
        PackageElement pkg = InvokablesProcessor.getPackageName(type);
        String packageName = pkg.getQualifiedName().toString();
        CompilationUnit compilationUnit = cu = pkg.isUnnamed() ? new CompilationUnit() : new CompilationUnit(packageName);
        if (!pkg.isUnnamed()) {
            cu.setPackageDeclaration(packageName);
            cu.addImport(type.getQualifiedName().toString());
        }
        cu.addImport("io.roastedroot.quickjs4j.core.Runner");
        cu.addImport("io.roastedroot.quickjs4j.core.Invokables");
        cu.addImport("io.roastedroot.quickjs4j.core.GuestFunction");
        cu.addImport("io.roastedroot.quickjs4j.core.HostRef");
        cu.addImport(List.class);
        String typeName = type.getSimpleName().toString();
        StringLiteralExpr processorName = new StringLiteralExpr(this.getClass().getName());
        String className = typeName + "_Invokables";
        ClassOrInterfaceDeclaration classDef = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)cu.addClass(className).setPublic(true)).setFinal(true)).addImplementedType(typeName)).addSingleMemberAnnotation(Generated.class, (Expression)processorName);
        classDef.addField(String.class, "jsLibrary", new Modifier.Keyword[]{Modifier.Keyword.FINAL});
        classDef.addField("io.roastedroot.quickjs4j.core.Runner", "runner", new Modifier.Keyword[]{Modifier.Keyword.FINAL});
        ConstructorDeclaration constructor = (ConstructorDeclaration)((ConstructorDeclaration)((ConstructorDeclaration)classDef.addConstructor(new Modifier.Keyword[0]).addParameter(String.class, "jsLibrary")).addParameter("io.roastedroot.quickjs4j.core.Runner", "runner")).setPrivate(true);
        ((BlockStmt)constructor.createBody().addStatement((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), "jsLibrary"), (Expression)new NameExpr("jsLibrary"), AssignExpr.Operator.ASSIGN))).addStatement((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), "runner"), (Expression)new NameExpr("runner"), AssignExpr.Operator.ASSIGN));
        ArrayList<Expression> functions = new ArrayList<Expression>();
        for (Element element : this.elements().getAllMembers(type)) {
            if (!(element instanceof ExecutableElement) || !InvokablesProcessor.annotatedWith(element, GuestFunction.class)) continue;
            String name = element.getAnnotation(GuestFunction.class).value();
            if (name.isEmpty()) {
                name = element.getSimpleName().toString();
            }
            ExecutableElement executable = (ExecutableElement)element;
            MethodDeclaration overriddenMethod = (MethodDeclaration)classDef.addMethod(element.getSimpleName().toString(), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addAnnotation(Override.class);
            NodeList arguments = NodeList.nodeList((Node[])new Expression[0]);
            for (int i = 0; i < executable.getParameters().size(); ++i) {
                overriddenMethod.addParameter(executable.getParameters().get(i).asType().toString(), "arg" + i);
                arguments.add((Node)new NameExpr("arg" + i));
            }
            MethodCallExpr argsList = new MethodCallExpr((Expression)new NameExpr("List"), new SimpleName("of"), arguments);
            BlockStmt methodBody = overriddenMethod.createBody();
            MethodCallExpr invocationHandle = new MethodCallExpr((Expression)new NameExpr("runner"), new SimpleName("invokeGuestFunction"), NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(moduleName), new StringLiteralExpr(name), argsList, new NameExpr("jsLibrary")}));
            boolean hasReturn = this.extractHasReturn(executable);
            if (hasReturn) {
                Type returnType = StaticJavaParser.parseType((String)executable.getReturnType().toString());
                overriddenMethod.setType(returnType);
                methodBody.addStatement((Statement)new ReturnStmt((Expression)new CastExpr(returnType, (Expression)invocationHandle)));
            } else {
                methodBody.addStatement((Expression)invocationHandle);
                methodBody.addStatement((Statement)new ReturnStmt((Expression)new NullLiteralExpr()));
            }
            functions.add(this.processGuestFunction((ExecutableElement)element));
        }
        ArrayCreationExpr newJsFunctions = new ArrayCreationExpr(StaticJavaParser.parseType((String)"GuestFunction"), new NodeList((Node[])new ArrayCreationLevel[]{new ArrayCreationLevel()}), new ArrayInitializerExpr(NodeList.nodeList(functions)));
        MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)new MethodCallExpr((Expression)new MethodCallExpr((Expression)new NameExpr("Invokables"), new SimpleName("builder"), NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(moduleName)})), new SimpleName("add"), NodeList.nodeList((Node[])new Expression[]{newJsFunctions})), new SimpleName("build"), NodeList.nodeList((Node[])new Expression[0]));
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)classDef.addMethod("toInvokables", new Modifier.Keyword[0]).setPublic(true)).setStatic(true)).setType("Invokables")).setBody(new BlockStmt(new NodeList((Node[])new Statement[]{new ReturnStmt((Expression)methodCallExpr)})));
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)classDef.addMethod("create", new Modifier.Keyword[0]).setPublic(true)).setStatic(true)).addParameter(String.class, "jsLibrary")).addParameter("io.roastedroot.quickjs4j.core.Runner", "runner")).setType(typeName)).setBody(new BlockStmt(new NodeList((Node[])new Statement[]{new ReturnStmt((Expression)new ObjectCreationExpr(null, StaticJavaParser.parseClassOrInterfaceType((String)className), NodeList.nodeList((Node[])new Expression[]{new NameExpr("jsLibrary"), new NameExpr("runner")})))})));
        Object prefix = pkg.isUnnamed() ? "" : packageName + ".";
        String qualifiedName = (String)prefix + String.valueOf(type.getSimpleName()) + "_Invokables";
        try (Writer writer = this.filer().createSourceFile(qualifiedName, type).openWriter();){
            writer.write(cu.printer((Printer)InvokablesProcessor.printer()).toString());
        }
        catch (IOException e) {
            this.log(Diagnostic.Kind.ERROR, String.format("Failed to create %s file: %s", qualifiedName, e), null);
        }
    }

    private Expression addPrimitiveReturn(String typeLiteral) {
        return new FieldAccessExpr((Expression)new NameExpr(typeLiteral), "class");
    }

    private Expression extractReturn(ExecutableElement executable) {
        Expression returnType;
        String returnName;
        switch (returnName = executable.getReturnType().toString()) {
            case "void": {
                returnType = new FieldAccessExpr((Expression)new NameExpr("java.lang.Void"), "class");
                break;
            }
            case "int": {
                returnType = this.addPrimitiveReturn("java.lang.Integer");
                break;
            }
            case "long": {
                returnType = this.addPrimitiveReturn("java.lang.Long");
                break;
            }
            case "double": {
                returnType = this.addPrimitiveReturn("java.lang.Double");
                break;
            }
            case "float": {
                returnType = this.addPrimitiveReturn("java.lang.Float");
                break;
            }
            case "boolean": {
                returnType = this.addPrimitiveReturn("java.lang.Boolean");
                break;
            }
            default: {
                if (InvokablesProcessor.annotatedWith(executable, ReturnsHostRef.class)) {
                    String javaRefType = "io.roastedroot.quickjs4j.core.HostRef";
                    returnType = new FieldAccessExpr((Expression)new NameExpr(javaRefType), "class");
                    break;
                }
                returnType = new FieldAccessExpr((Expression)new NameExpr(returnName), "class");
            }
        }
        return returnType;
    }

    NodeList<Expression> extractParameters(ExecutableElement executable) {
        NodeList paramTypes = new NodeList();
        block14: for (VariableElement variableElement : executable.getParameters()) {
            switch (variableElement.asType().toString()) {
                case "int": {
                    paramTypes.add((Node)new FieldAccessExpr((Expression)new NameExpr("java.lang.Integer"), "class"));
                    continue block14;
                }
                case "long": {
                    paramTypes.add((Node)new FieldAccessExpr((Expression)new NameExpr("java.lang.Long"), "class"));
                    continue block14;
                }
                case "double": {
                    paramTypes.add((Node)new FieldAccessExpr((Expression)new NameExpr("java.lang.Double"), "class"));
                    continue block14;
                }
                case "float": {
                    paramTypes.add((Node)new FieldAccessExpr((Expression)new NameExpr("java.lang.Float"), "class"));
                    continue block14;
                }
                case "boolean": {
                    paramTypes.add((Node)new FieldAccessExpr((Expression)new NameExpr("java.lang.Boolean"), "class"));
                    continue block14;
                }
            }
            String typeLiteral = variableElement.asType().toString();
            if (InvokablesProcessor.annotatedWith(variableElement, HostRefParam.class)) {
                String javaRefType = "io.roastedroot.quickjs4j.core.HostRef";
                paramTypes.add((Node)new FieldAccessExpr((Expression)new NameExpr(javaRefType), "class"));
                continue;
            }
            paramTypes.add((Node)new FieldAccessExpr((Expression)new NameExpr(typeLiteral), "class"));
        }
        return paramTypes;
    }

    private Expression processGuestFunction(ExecutableElement executable) {
        String name = executable.getAnnotation(GuestFunction.class).value();
        if (name.isEmpty()) {
            name = executable.getSimpleName().toString();
        }
        NodeList<Expression> paramTypes = this.extractParameters(executable);
        String returnName = executable.getReturnType().toString();
        Expression returnType = this.extractReturn(executable);
        ObjectCreationExpr function = (ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)new ObjectCreationExpr().setType("GuestFunction")).addArgument((Expression)new StringLiteralExpr(name))).addArgument((Expression)new MethodCallExpr((Expression)new NameExpr("List"), "of", paramTypes))).addArgument(returnType);
        function.setLineComment("");
        return function;
    }
}

