/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.quickjs4j.processor;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.printer.Printer;
import io.roastedroot.quickjs4j.annotations.Builtins;
import io.roastedroot.quickjs4j.annotations.HostFunction;
import io.roastedroot.quickjs4j.annotations.HostRefParam;
import io.roastedroot.quickjs4j.annotations.ReturnsHostRef;
import io.roastedroot.quickjs4j.processor.Quickjs4jAbstractProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

public final class BuiltinsProcessor
extends Quickjs4jAbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Builtins.class)) {
            this.log(Diagnostic.Kind.NOTE, "Generating Builtins for " + String.valueOf(element), null);
            try {
                this.processBuiltins((TypeElement)element);
            }
            catch (Quickjs4jAbstractProcessor.AbortProcessingException abortProcessingException) {}
        }
        return false;
    }

    private void processBuiltins(TypeElement type) {
        Writer writer;
        CompilationUnit cu;
        String name = type.getAnnotation(Builtins.class).value();
        if (name.isEmpty()) {
            name = type.getSimpleName().toString();
        }
        StringBuilder mjsBuilder = new StringBuilder();
        mjsBuilder.append("// File generated by QuickJs4j\n\n");
        ArrayList<Expression> functions = new ArrayList<Expression>();
        for (Element element : this.elements().getAllMembers(type)) {
            if (!(element instanceof ExecutableElement) || !BuiltinsProcessor.annotatedWith(element, HostFunction.class)) continue;
            functions.add(this.processHostFunction((ExecutableElement)element, name, mjsBuilder));
        }
        PackageElement pkg = BuiltinsProcessor.getPackageName(type);
        String string = pkg.getQualifiedName().toString();
        CompilationUnit compilationUnit = cu = pkg.isUnnamed() ? new CompilationUnit() : new CompilationUnit(string);
        if (!pkg.isUnnamed()) {
            cu.setPackageDeclaration(string);
            cu.addImport(type.getQualifiedName().toString());
        }
        cu.addImport("io.roastedroot.quickjs4j.core.Builtins");
        cu.addImport("io.roastedroot.quickjs4j.core.HostFunction");
        cu.addImport("io.roastedroot.quickjs4j.core.HostRef");
        cu.addImport(List.class);
        String typeName = type.getSimpleName().toString();
        StringLiteralExpr processorName = new StringLiteralExpr(this.getClass().getName());
        ClassOrInterfaceDeclaration classDef = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)cu.addClass(typeName + "_Builtins").setPublic(true)).setFinal(true)).addSingleMemberAnnotation(Generated.class, (Expression)processorName);
        classDef.addConstructor(new Modifier.Keyword[0]).setPrivate(true);
        ArrayCreationExpr newJsFunctions = new ArrayCreationExpr(StaticJavaParser.parseType((String)"HostFunction"), new NodeList((Node[])new ArrayCreationLevel[]{new ArrayCreationLevel()}), new ArrayInitializerExpr(NodeList.nodeList(functions)));
        MethodCallExpr builtinsCreationHandle = new MethodCallExpr((Expression)new MethodCallExpr((Expression)new MethodCallExpr((Expression)new NameExpr("Builtins"), new SimpleName("builder"), NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(name)})), new SimpleName("add"), NodeList.nodeList((Node[])new Expression[]{newJsFunctions})), new SimpleName("build"), NodeList.nodeList((Node[])new Expression[0]));
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)classDef.addMethod("toBuiltins", new Modifier.Keyword[0]).setPublic(true)).setStatic(true)).addParameter(typeName, "jsModule")).setType("Builtins")).setBody(new BlockStmt(new NodeList((Node[])new Statement[]{new ReturnStmt((Expression)builtinsCreationHandle)})));
        Object prefix = pkg.isUnnamed() ? "" : string + ".";
        String qualifiedName = (String)prefix + String.valueOf(type.getSimpleName()) + "_Builtins";
        try {
            writer = this.filer().createSourceFile(qualifiedName, type).openWriter();
            try {
                writer.write(cu.printer((Printer)BuiltinsProcessor.printer()).toString());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            this.log(Diagnostic.Kind.ERROR, String.format("Failed to create %s file: %s", qualifiedName, e), null);
        }
        try {
            writer = this.filer().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/quickjs4j/" + name + ".mjs", new Element[0]).openWriter();
            try {
                writer.write(mjsBuilder.toString());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            this.log(Diagnostic.Kind.ERROR, String.format("Failed to create %s file: %s", qualifiedName, e), null);
        }
    }

    private void addPrimitiveParam(String typeLiteral, NodeList<Expression> paramTypes, NodeList<Expression> arguments) {
        Type type = StaticJavaParser.parseType((String)typeLiteral);
        arguments.add((Node)new CastExpr(type, BuiltinsProcessor.argExpr(paramTypes.size())));
        paramTypes.add((Node)new FieldAccessExpr((Expression)new NameExpr(typeLiteral), "class"));
    }

    private Expression addPrimitiveReturn(String typeLiteral) {
        return new FieldAccessExpr((Expression)new NameExpr(typeLiteral), "class");
    }

    private Expression extractReturn(ExecutableElement executable) {
        Expression returnType;
        String returnName;
        switch (returnName = executable.getReturnType().toString()) {
            case "void": {
                returnType = new FieldAccessExpr((Expression)new NameExpr("java.lang.Void"), "class");
                break;
            }
            case "int": {
                returnType = this.addPrimitiveReturn("java.lang.Integer");
                break;
            }
            case "long": {
                returnType = this.addPrimitiveReturn("java.lang.Long");
                break;
            }
            case "double": {
                returnType = this.addPrimitiveReturn("java.lang.Double");
                break;
            }
            case "float": {
                returnType = this.addPrimitiveReturn("java.lang.Float");
                break;
            }
            case "boolean": {
                returnType = this.addPrimitiveReturn("java.lang.Boolean");
                break;
            }
            default: {
                if (BuiltinsProcessor.annotatedWith(executable, ReturnsHostRef.class)) {
                    String javaRefType = "io.roastedroot.quickjs4j.core.HostRef";
                    returnType = new FieldAccessExpr((Expression)new NameExpr(javaRefType), "class");
                    break;
                }
                returnType = new FieldAccessExpr((Expression)new NameExpr(returnName), "class");
            }
        }
        return returnType;
    }

    private Expression processHostFunction(ExecutableElement executable, String moduleName, StringBuilder mjsBuilder) {
        String name = executable.getAnnotation(HostFunction.class).value();
        if (name.isEmpty()) {
            name = executable.getSimpleName().toString();
        }
        NodeList paramTypes = new NodeList();
        NodeList arguments = new NodeList();
        block14: for (VariableElement variableElement : executable.getParameters()) {
            switch (variableElement.asType().toString()) {
                case "int": {
                    this.addPrimitiveParam("java.lang.Integer", (NodeList<Expression>)paramTypes, (NodeList<Expression>)arguments);
                    continue block14;
                }
                case "long": {
                    this.addPrimitiveParam("java.lang.Long", (NodeList<Expression>)paramTypes, (NodeList<Expression>)arguments);
                    continue block14;
                }
                case "double": {
                    this.addPrimitiveParam("java.lang.Double", (NodeList<Expression>)paramTypes, (NodeList<Expression>)arguments);
                    continue block14;
                }
                case "float": {
                    this.addPrimitiveParam("java.lang.Float", (NodeList<Expression>)paramTypes, (NodeList<Expression>)arguments);
                    continue block14;
                }
                case "boolean": {
                    this.addPrimitiveParam("java.lang.Boolean", (NodeList<Expression>)paramTypes, (NodeList<Expression>)arguments);
                    continue block14;
                }
            }
            String typeLiteral = variableElement.asType().toString();
            Type type = StaticJavaParser.parseType((String)variableElement.asType().toString());
            arguments.add((Node)new CastExpr(type, BuiltinsProcessor.argExpr(paramTypes.size())));
            if (BuiltinsProcessor.annotatedWith(variableElement, HostRefParam.class)) {
                String javaRefType = "io.roastedroot.quickjs4j.core.HostRef";
                paramTypes.add((Node)new FieldAccessExpr((Expression)new NameExpr(javaRefType), "class"));
                continue;
            }
            paramTypes.add((Node)new FieldAccessExpr((Expression)new NameExpr(typeLiteral), "class"));
        }
        Expression returnType = this.extractReturn(executable);
        boolean bl = this.extractHasReturn(executable);
        MethodCallExpr invocation = new MethodCallExpr((Expression)new NameExpr("jsModule"), executable.getSimpleName().toString(), arguments);
        BlockStmt handleBody = new BlockStmt();
        if (!bl) {
            ((BlockStmt)handleBody.addStatement((Expression)invocation)).addStatement((Statement)new ReturnStmt((Expression)new NullLiteralExpr()));
        } else {
            VariableDeclarator result = new VariableDeclarator(StaticJavaParser.parseType((String)executable.getReturnType().toString()), "result", (Expression)invocation);
            ((BlockStmt)handleBody.addStatement((Statement)new ExpressionStmt((Expression)new VariableDeclarationExpr(result)))).addStatement((Statement)new ReturnStmt((Expression)new NameExpr("result")));
        }
        LambdaExpr handle = ((LambdaExpr)new LambdaExpr().addParameter(new Parameter(StaticJavaParser.parseType((String)"List<Object>"), "args"))).setEnclosingParameters(true).setBody((Statement)handleBody);
        ObjectCreationExpr function = (ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)new ObjectCreationExpr().setType("HostFunction")).addArgument((Expression)new StringLiteralExpr(name))).addArgument((Expression)new MethodCallExpr((Expression)new NameExpr("List"), "of", paramTypes))).addArgument(returnType)).addArgument((Expression)handle);
        function.setLineComment("");
        StringBuilder jsParams = new StringBuilder();
        for (int i = 0; i < paramTypes.size(); ++i) {
            if (i > 0) {
                jsParams.append(", ");
            }
            jsParams.append("args" + i);
        }
        mjsBuilder.append("export function " + name + "(" + String.valueOf(jsParams) + ") {\n");
        String baseInvoke = moduleName + "." + name + "(" + String.valueOf(jsParams) + ")";
        if (bl) {
            mjsBuilder.append("  return " + baseInvoke + ";\n");
        } else {
            mjsBuilder.append("  " + baseInvoke + ";\n");
        }
        mjsBuilder.append("}\n");
        return function;
    }

    private static Expression argExpr(int n) {
        return new MethodCallExpr((Expression)new NameExpr("args"), new SimpleName("get"), NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(String.valueOf(n))}));
    }
}

