/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.sql.defaults;

import io.resys.thena.docdb.api.models.ImmutableBlob;
import io.resys.thena.docdb.api.models.ImmutableCommit;
import io.resys.thena.docdb.api.models.ImmutableRef;
import io.resys.thena.docdb.api.models.ImmutableRepo;
import io.resys.thena.docdb.api.models.ImmutableTag;
import io.resys.thena.docdb.api.models.ImmutableTree;
import io.resys.thena.docdb.api.models.ImmutableTreeValue;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.sql.SqlMapper;
import io.vertx.mutiny.sqlclient.Row;
import java.time.LocalDateTime;
import java.util.Optional;

public class DefaultSqlMapper
implements SqlMapper {
    private final ClientCollections ctx;

    public DefaultSqlMapper(ClientCollections ctx) {
        this.ctx = ctx;
    }

    @Override
    public Repo repo(Row row) {
        return ImmutableRepo.builder().id(row.getString("id")).rev(row.getString("rev")).name(row.getString("name")).prefix(row.getString("prefix")).build();
    }

    @Override
    public Objects.Commit commit(Row row) {
        return ImmutableCommit.builder().id(row.getString("id")).author(row.getString("author")).dateTime(LocalDateTime.parse(row.getString("datetime"))).message(row.getString("message")).parent(Optional.ofNullable(row.getString("parent"))).merge(Optional.ofNullable(row.getString("merge"))).tree(row.getString("tree")).build();
    }

    @Override
    public Objects.Tree tree(Row row) {
        return ImmutableTree.builder().id(row.getString("id")).build();
    }

    @Override
    public Objects.TreeValue treeItem(Row row) {
        return ImmutableTreeValue.builder().name(row.getString("name")).blob(row.getString("blob")).build();
    }

    @Override
    public Objects.Tag tag(Row row) {
        return ImmutableTag.builder().author(row.getString("author")).dateTime(LocalDateTime.parse(row.getString("datetime"))).message(row.getString("message")).commit(row.getString("commit")).name(row.getString("id")).build();
    }

    @Override
    public Objects.Ref ref(Row row) {
        return ImmutableRef.builder().name(row.getString("name")).commit(row.getString("commit")).build();
    }

    @Override
    public Objects.Blob blob(Row row) {
        return ImmutableBlob.builder().id(row.getString("id")).value(row.getString("value")).build();
    }
}

