/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.sql.defaults;

import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.sql.ImmutableSql;
import io.resys.thena.docdb.spi.sql.ImmutableSqlTuple;
import io.resys.thena.docdb.spi.sql.SqlBuilder;
import io.resys.thena.docdb.spi.sql.defaults.SqlStatement;
import io.vertx.mutiny.sqlclient.Tuple;

public class DefaultRepoSqlBuilder
implements SqlBuilder.RepoSqlBuilder {
    private final ClientCollections options;

    public DefaultRepoSqlBuilder(ClientCollections options) {
        this.options = options;
    }

    @Override
    public SqlBuilder.SqlTuple exists() {
        return ImmutableSqlTuple.builder().value(new SqlStatement().ln().append("SELECT EXISTS").ln().append("(").ln().append("  SELECT table_name").ln().append("  FROM information_schema.tables").ln().append("  WHERE table_name = ?1").ln().append(")").ln().build()).props(Tuple.of((Object)this.options.getRepos())).build();
    }

    @Override
    public SqlBuilder.Sql create() {
        return ImmutableSql.builder().value(new SqlStatement().append("CREATE TABLE IF NOT EXISTS ").append(this.options.getRepos()).ln().append("(").ln().append("  id VARCHAR(40) PRIMARY KEY,").ln().append("  rev VARCHAR(40) NOT NULL,").ln().append("  prefix VARCHAR(40) NOT NULL,").ln().append("  name VARCHAR(255) NOT NULL,").ln().append("  UNIQUE(name), UNIQUE(rev), UNIQUE(prefix)").ln().append(")").ln().build()).build();
    }

    @Override
    public SqlBuilder.Sql findAll() {
        return ImmutableSql.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getRepos()).build()).build();
    }

    @Override
    public SqlBuilder.SqlTuple getByName(String name) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getRepos()).append(" WHERE name = $1").append(" FETCH FIRST ROW ONLY").build()).props(Tuple.of((Object)name)).build();
    }

    @Override
    public SqlBuilder.SqlTuple getByNameOrId(String name) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getRepos()).append(" WHERE name = $1 OR id = $1").append(" FETCH FIRST ROW ONLY").build()).props(Tuple.of((Object)name)).build();
    }

    @Override
    public SqlBuilder.SqlTuple insertOne(Repo newRepo) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("INSERT INTO ").append(this.options.getRepos()).append("(id, rev, prefix, name) VALUES($1, $2, $3, $4)").build()).props(Tuple.of((Object)newRepo.getId(), (Object)newRepo.getRev(), (Object)newRepo.getPrefix(), (Object)newRepo.getName())).build();
    }
}

