/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.sql.defaults;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.sql.ImmutableSql;
import io.resys.thena.docdb.spi.sql.ImmutableSqlTuple;
import io.resys.thena.docdb.spi.sql.SqlBuilder;
import io.resys.thena.docdb.spi.sql.defaults.SqlStatement;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.List;

public class DefaultBlobSqlBuilder
implements SqlBuilder.BlobSqlBuilder {
    private final ClientCollections options;

    public DefaultBlobSqlBuilder(ClientCollections options) {
        this.options = options;
    }

    @Override
    public SqlBuilder.Sql create() {
        return ImmutableSql.builder().value(new SqlStatement().ln().append("CREATE TABLE ").append(this.options.getBlobs()).ln().append("(").ln().append("  id VARCHAR(40) PRIMARY KEY,").ln().append("  value TEXT NOT NULL").ln().append(");").ln().build()).build();
    }

    @Override
    public SqlBuilder.Sql findAll() {
        return ImmutableSql.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getBlobs()).build()).build();
    }

    @Override
    public SqlBuilder.SqlTuple getById(String blobId) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getBlobs()).append(" WHERE id = $1").append(" FETCH FIRST ROW ONLY").build()).props(Tuple.of((Object)blobId)).build();
    }

    @Override
    public SqlBuilder.SqlTuple findByIds(List<String> blobId) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getBlobs()).append(" WHERE id IN(?1)").build()).props(Tuple.of(blobId)).build();
    }

    @Override
    public SqlBuilder.SqlTuple findByTree(Objects.Tree tree) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT blob.* ").ln().append("  FROM ").append(this.options.getBlobs()).append(" AS blob ").ln().append("  LEFT JOIN ").append(this.options.getTreeItems()).append(" AS item ").ln().append("  ON blob.id = item.blob").ln().append("  WHERE item.tree = $1").ln().append(" ").build()).props(Tuple.of((Object)tree.getId())).build();
    }

    @Override
    public SqlBuilder.SqlTuple insertOne(Objects.Blob blob) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("INSERT INTO ").append(this.options.getBlobs()).append("(id, value) VALUES($1, $2)").build()).props(Tuple.of((Object)blob.getId(), (Object)blob.getValue())).build();
    }
}

