/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.sql;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.List;
import org.immutables.value.Value;

public interface SqlBuilder {
    public RepoSqlBuilder repo();

    public RefSqlBuilder refs();

    public TagSqlBuilder tags();

    public BlobSqlBuilder blobs();

    public CommitSqlBuilder commits();

    public TreeSqlBuilder trees();

    public TreeItemSqlBuilder treeItems();

    public SqlBuilder withOptions(ClientCollections var1);

    @Value.Immutable
    public static interface SqlTupleList {
        public String getValue();

        public List<Tuple> getProps();
    }

    @Value.Immutable
    public static interface SqlTuple {
        public String getValue();

        public Tuple getProps();
    }

    @Value.Immutable
    public static interface Sql {
        public String getValue();
    }

    public static interface TreeItemSqlBuilder {
        public Sql create();

        public Sql constraints();

        public SqlTuple getByTreeId(String var1);

        public Sql findAll();

        public SqlTuple insertOne(Objects.Tree var1, Objects.TreeValue var2);

        public SqlTupleList insertAll(Objects.Tree var1);
    }

    public static interface CommitSqlBuilder {
        public Sql create();

        public Sql constraints();

        public SqlTuple getById(String var1);

        public Sql findAll();

        public SqlTuple insertOne(Objects.Commit var1);
    }

    public static interface TreeSqlBuilder {
        public Sql create();

        public SqlTuple getById(String var1);

        public Sql findAll();

        public SqlTuple insertOne(Objects.Tree var1);
    }

    public static interface TagSqlBuilder {
        public Sql create();

        public Sql constraints();

        public SqlTuple getByName(String var1);

        public SqlTuple deleteByName(String var1);

        public Sql findAll();

        public Sql getFirst();

        public SqlTuple insertOne(Objects.Tag var1);
    }

    public static interface RefSqlBuilder {
        public Sql create();

        public Sql constraints();

        public SqlTuple getByName(String var1);

        public SqlTuple getByNameOrCommit(String var1);

        public Sql getFirst();

        public Sql findAll();

        public SqlTuple insertOne(Objects.Ref var1);

        public SqlTuple updateOne(Objects.Ref var1, Objects.Commit var2);
    }

    public static interface BlobSqlBuilder {
        public Sql create();

        public SqlTuple getById(String var1);

        public SqlTuple findByIds(List<String> var1);

        public SqlTuple findByTree(Objects.Tree var1);

        public SqlTuple insertOne(Objects.Blob var1);

        public Sql findAll();
    }

    public static interface RepoSqlBuilder {
        public SqlTuple exists();

        public Sql create();

        public Sql findAll();

        public SqlTuple getByName(String var1);

        public SqlTuple getByNameOrId(String var1);

        public SqlTuple insertOne(Repo var1);
    }
}

