/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.pgsql.support;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.pgsql.support.ClientWrapper;
import io.vertx.mutiny.pgclient.PgPool;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientWrapper", generator="Immutables")
@Immutable
public final class ImmutableClientWrapper
implements ClientWrapper {
    private final Repo repo;
    private final PgPool client;
    private final ClientCollections names;

    private ImmutableClientWrapper(Repo repo, PgPool client, ClientCollections names) {
        this.repo = repo;
        this.client = client;
        this.names = names;
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    @Override
    public PgPool getClient() {
        return this.client;
    }

    @Override
    public ClientCollections getNames() {
        return this.names;
    }

    public final ImmutableClientWrapper withRepo(Repo value) {
        if (this.repo == value) {
            return this;
        }
        Repo newValue = Objects.requireNonNull(value, "repo");
        return new ImmutableClientWrapper(newValue, this.client, this.names);
    }

    public final ImmutableClientWrapper withClient(PgPool value) {
        if (this.client == value) {
            return this;
        }
        PgPool newValue = Objects.requireNonNull(value, "client");
        return new ImmutableClientWrapper(this.repo, newValue, this.names);
    }

    public final ImmutableClientWrapper withNames(ClientCollections value) {
        if (this.names == value) {
            return this;
        }
        ClientCollections newValue = Objects.requireNonNull(value, "names");
        return new ImmutableClientWrapper(this.repo, this.client, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientWrapper && this.equalTo((ImmutableClientWrapper)another);
    }

    private boolean equalTo(ImmutableClientWrapper another) {
        return this.repo.equals(another.repo) && this.client.equals((Object)another.client) && this.names.equals(another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + this.names.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ClientWrapper").omitNullValues().add("repo", (Object)this.repo).add("client", (Object)this.client).add("names", (Object)this.names).toString();
    }

    public static ImmutableClientWrapper copyOf(ClientWrapper instance) {
        if (instance instanceof ImmutableClientWrapper) {
            return (ImmutableClientWrapper)instance;
        }
        return ImmutableClientWrapper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClientWrapper", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPO = 1L;
        private static final long INIT_BIT_CLIENT = 2L;
        private static final long INIT_BIT_NAMES = 4L;
        private long initBits = 7L;
        @Nullable
        private Repo repo;
        @Nullable
        private PgPool client;
        @Nullable
        private ClientCollections names;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ClientWrapper instance) {
            Objects.requireNonNull(instance, "instance");
            this.repo(instance.getRepo());
            this.client(instance.getClient());
            this.names(instance.getNames());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(Repo repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(PgPool client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder names(ClientCollections names) {
            this.names = Objects.requireNonNull(names, "names");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableClientWrapper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClientWrapper(this.repo, this.client, this.names);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("client");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("names");
            }
            return "Cannot build ClientWrapper, some of required attributes are not set " + attributes;
        }
    }
}

