/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.pgsql.builders;

import io.resys.thena.docdb.api.models.ImmutableTree;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.pgsql.sql.PgErrors;
import io.resys.thena.docdb.spi.sql.SqlBuilder;
import io.resys.thena.docdb.spi.sql.SqlMapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.pgclient.PgPool;
import io.vertx.mutiny.sqlclient.Row;

public class PgTreeQuery
implements ClientQuery.TreeQuery {
    private final PgPool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;

    public PgTreeQuery(PgPool client, ClientCollections names, SqlMapper sqlMapper, SqlBuilder sqlBuilder) {
        this.client = client;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
    }

    public Uni<Objects.Tree> id(String tree) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.treeItems().getByTreeId(tree);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.treeItem((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            ImmutableTree.Builder builder = ImmutableTree.builder().id(tree);
            for (Objects.TreeValue item : rowset) {
                builder.putValues(item.getName(), item);
            }
            return builder.build();
        }).onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'TREE'!", e));
    }

    public Multi<Objects.Tree> find() {
        SqlBuilder.Sql sql = this.sqlBuilder.trees().findAll();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.tree((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'TREE'!", e));
    }
}

