/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.pgsql.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.pgsql.sql.PgErrors;
import io.resys.thena.docdb.spi.sql.SqlBuilder;
import io.resys.thena.docdb.spi.sql.SqlMapper;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.pgclient.PgPool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;

public class PgRefQuery
implements ClientQuery.RefQuery {
    private final PgPool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;

    public PgRefQuery(PgPool client, ClientCollections names, SqlMapper sqlMapper, SqlBuilder sqlBuilder) {
        this.client = client;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
    }

    public Uni<Objects.Ref> nameOrCommit(String refNameOrCommit) {
        RepoAssert.notEmpty((String)refNameOrCommit, () -> "refNameOrCommit must be defined!");
        SqlBuilder.SqlTuple sql = this.sqlBuilder.refs().getByNameOrCommit(refNameOrCommit);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.ref((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Ref)it.next();
            }
            return null;
        }).onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'REF' by refNameOrCommit: '" + refNameOrCommit + "'!", e));
    }

    public Uni<Objects.Ref> get() {
        SqlBuilder.Sql sql = this.sqlBuilder.refs().getFirst();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.ref((Row)row)).execute().onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Ref)it.next();
            }
            return null;
        }).onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'REF'!", e));
    }

    public Multi<Objects.Ref> find() {
        SqlBuilder.Sql sql = this.sqlBuilder.refs().findAll();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.ref((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'REF'!", e));
    }

    public Uni<Objects.Ref> name(String name) {
        RepoAssert.notEmpty((String)name, () -> "name must be defined!");
        SqlBuilder.SqlTuple sql = this.sqlBuilder.refs().getByName(name);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.ref((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Ref)it.next();
            }
            return null;
        }).onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'REF' by name: '" + name + "'!", e));
    }
}

