/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.pgsql.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.pgsql.sql.PgErrors;
import io.resys.thena.docdb.spi.sql.SqlBuilder;
import io.resys.thena.docdb.spi.sql.SqlMapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.pgclient.PgPool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;

public class PgCommitQuery
implements ClientQuery.CommitQuery {
    private final PgPool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;

    public PgCommitQuery(PgPool client, ClientCollections names, SqlMapper sqlMapper, SqlBuilder sqlBuilder) {
        this.client = client;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
    }

    public Uni<Objects.Commit> id(String commit) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.commits().getById(commit);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.commit((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Commit)it.next();
            }
            return null;
        }).onFailure(e -> PgErrors.notFound(e)).recoverWithNull().onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'COMMIT' by 'id': '" + commit + "'!", e));
    }

    public Multi<Objects.Commit> find() {
        SqlBuilder.Sql sql = this.sqlBuilder.commits().findAll();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.commit((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'COMMIT'!", e));
    }
}

