/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.pgsql.builders;

import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientInsertBuilder;
import io.resys.thena.docdb.spi.ImmutableInsertResult;
import io.resys.thena.docdb.spi.ImmutableUpsertResult;
import io.resys.thena.docdb.spi.pgsql.sql.PgErrors;
import io.resys.thena.docdb.spi.pgsql.support.ClientWrapper;
import io.resys.thena.docdb.spi.sql.SqlBuilder;
import io.resys.thena.docdb.spi.sql.SqlMapper;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.pgclient.PgPool;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;
import io.vertx.mutiny.sqlclient.SqlClientHelper;

public class PgClientInsertBuilder
implements ClientInsertBuilder {
    private final PgPool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;

    public PgClientInsertBuilder(ClientWrapper wrapper, SqlMapper sqlMapper, SqlBuilder sqlBuilder) {
        this.client = wrapper.getClient();
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
    }

    public Uni<ClientInsertBuilder.InsertResult> tag(Objects.Tag tag) {
        SqlBuilder.SqlTuple tagInsert = this.sqlBuilder.tags().insertOne(tag);
        return this.client.preparedQuery(tagInsert.getValue()).execute(tagInsert.getProps()).onItem().transform(inserted -> ImmutableInsertResult.builder().duplicate(false).build()).onFailure(e -> PgErrors.duplicate(e)).recoverWithItem(e -> ImmutableInsertResult.builder().duplicate(true).build()).onFailure().invoke(e -> PgErrors.deadEnd("Can't insert into 'TAG': '" + tagInsert.getValue() + "'!", e));
    }

    public Uni<ClientInsertBuilder.UpsertResult> blob(Objects.Blob blob) {
        SqlBuilder.SqlTuple blobsInsert = this.sqlBuilder.blobs().insertOne(blob);
        return this.client.preparedQuery(blobsInsert.getValue()).execute(blobsInsert.getProps()).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(blob.getId()).isModified(true).target((Object)blob).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Blob with id:" + " '" + blob.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> PgErrors.duplicate(e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(blob.getId()).isModified(false).target((Object)blob).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Blob with id:" + " '" + blob.getId() + "'" + " is already saved.").build()).build()).onFailure().invoke(e -> PgErrors.deadEnd("Can't insert into 'BLOB': '" + blobsInsert.getValue() + "'!", e));
    }

    public Uni<ClientInsertBuilder.UpsertResult> ref(Objects.Ref ref, Objects.Commit commit) {
        SqlBuilder.SqlTuple findByName = this.sqlBuilder.refs().getByName(ref.getName());
        return this.client.preparedQuery(findByName.getValue()).mapping(r -> this.sqlMapper.ref((Row)r)).execute(findByName.getProps()).onItem().transformToUni(item -> {
            RowIterator exists = item.iterator();
            if (!exists.hasNext()) {
                return this.createRef(ref, commit);
            }
            return this.updateRef((Objects.Ref)exists.next(), commit);
        });
    }

    public Uni<ClientInsertBuilder.UpsertResult> updateRef(Objects.Ref ref, Objects.Commit commit) {
        SqlBuilder.SqlTuple refInsert = this.sqlBuilder.refs().updateOne(ref, commit);
        return this.client.preparedQuery(refInsert.getValue()).execute(refInsert.getProps()).onItem().transform(updateResult -> {
            if (updateResult.size() == 1) {
                return ImmutableUpsertResult.builder().id(ref.getName()).isModified(true).status(ClientInsertBuilder.UpsertStatus.OK).target((Object)ref).message((Message)ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " has been updated.").build()).build();
            }
            return ImmutableUpsertResult.builder().id(ref.getName()).isModified(false).status(ClientInsertBuilder.UpsertStatus.CONFLICT).target((Object)ref).message((Message)ImmutableMessage.builder().text("Ref with" + " id: '" + ref.getName() + "'," + " commit: '" + ref.getCommit() + "'" + " is behind of the head.").build()).build();
        });
    }

    private Uni<ClientInsertBuilder.UpsertResult> createRef(Objects.Ref ref, Objects.Commit commit) {
        SqlBuilder.SqlTuple refsInsert = this.sqlBuilder.refs().insertOne(ref);
        return this.client.preparedQuery(refsInsert.getValue()).execute(refsInsert.getProps()).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(ref.getName()).isModified(true).target((Object)ref).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " has been created.").build()).build()).onFailure(e -> PgErrors.duplicate(e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(ref.getName()).isModified(false).target((Object)ref).status(ClientInsertBuilder.UpsertStatus.CONFLICT).message((Message)ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " is already created.").build()).build()).onFailure().invoke(e -> PgErrors.deadEnd("Can't insert into 'REF': '" + refsInsert.getValue() + "'!", e));
    }

    public Uni<ClientInsertBuilder.UpsertResult> tree(Objects.Tree tree) {
        SqlBuilder.SqlTuple treeInsert = this.sqlBuilder.trees().insertOne(tree);
        SqlBuilder.SqlTupleList treeValueInsert = this.sqlBuilder.treeItems().insertAll(tree);
        return SqlClientHelper.inTransactionUni((Pool)this.client, tx -> tx.preparedQuery(treeInsert.getValue()).execute(treeInsert.getProps()).onItem().transformToUni(junk -> tx.preparedQuery(treeValueInsert.getValue()).executeBatch(treeValueInsert.getProps()))).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(tree.getId()).isModified(true).target((Object)tree).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Tree with id:" + " '" + tree.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> PgErrors.duplicate(e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(tree.getId()).isModified(false).target((Object)tree).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Tree with id:" + " '" + tree.getId() + "'" + " is already saved.").build()).build()).onFailure().invoke(e -> PgErrors.deadEnd("Can't insert into \r\n'TREE': " + treeInsert.getValue() + "\r\n  and/or\r\n 'TREE_VALUE' : '" + treeValueInsert.getValue() + "'!", e));
    }

    public Uni<ClientInsertBuilder.UpsertResult> commit(Objects.Commit commit) {
        SqlBuilder.SqlTuple commitsInsert = this.sqlBuilder.commits().insertOne(commit);
        return this.client.preparedQuery(commitsInsert.getValue()).execute(commitsInsert.getProps()).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(commit.getId()).isModified(true).target((Object)commit).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Commit with id:" + " '" + commit.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> PgErrors.duplicate(e)).recoverWithItem(e -> ImmutableUpsertResult.builder().id(commit.getId()).isModified(false).target((Object)commit).status(ClientInsertBuilder.UpsertStatus.CONFLICT).message((Message)ImmutableMessage.builder().text("Commit with id:" + " '" + commit.getId() + "'" + " is already saved.").build()).build()).onFailure().invoke(e -> PgErrors.deadEnd("Can't insert into 'COMMIT': '" + commitsInsert.getValue() + "'!", e));
    }
}

