/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.pgsql.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.pgsql.sql.PgErrors;
import io.resys.thena.docdb.spi.sql.SqlBuilder;
import io.resys.thena.docdb.spi.sql.SqlMapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.pgclient.PgPool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;
import java.util.ArrayList;
import java.util.List;

public class PgBlobQuery
implements ClientQuery.BlobQuery {
    private final PgPool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;

    public PgBlobQuery(PgPool client, ClientCollections names, SqlMapper sqlMapper, SqlBuilder sqlBuilder) {
        this.client = client;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
    }

    public Uni<Objects.Blob> id(String blobId) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.blobs().getById(blobId);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.blob((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Blob)it.next();
            }
            return null;
        }).onFailure(e -> PgErrors.notFound(e)).recoverWithNull().onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'BLOB' by 'id': '" + blobId + "'!", e));
    }

    public Uni<List<Objects.Blob>> id(List<String> blobId) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.blobs().findByIds(blobId);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.blob((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            ArrayList<Objects.Blob> result = new ArrayList<Objects.Blob>();
            for (Objects.Blob item : rowset) {
                result.add(item);
            }
            return result;
        }).onFailure(e -> PgErrors.notFound(e)).recoverWithNull().onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'BLOB' by 'id'-s: '" + String.join((CharSequence)",", blobId) + "'!", e));
    }

    public Multi<Objects.Blob> find() {
        SqlBuilder.Sql sql = this.sqlBuilder.blobs().findAll();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.blob((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'BLOB'!", e));
    }

    public Multi<Objects.Blob> find(Objects.Tree tree) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.blobs().findByTree(tree);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.blob((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> PgErrors.deadEnd("Can't find 'BLOB' by tree: " + tree.getId() + "!", e));
    }
}

