/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.pgsql;

import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientInsertBuilder;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.DocDBDefault;
import io.resys.thena.docdb.spi.pgsql.PgClientQuery;
import io.resys.thena.docdb.spi.pgsql.builders.PgClientInsertBuilder;
import io.resys.thena.docdb.spi.pgsql.builders.PgRepoBuilder;
import io.resys.thena.docdb.spi.pgsql.support.ImmutableClientWrapper;
import io.resys.thena.docdb.spi.sql.SqlBuilder;
import io.resys.thena.docdb.spi.sql.SqlMapper;
import io.resys.thena.docdb.spi.sql.defaults.DefaultSqlBuilder;
import io.resys.thena.docdb.spi.sql.defaults.DefaultSqlMapper;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.pgclient.PgPool;

public class DocDBFactory {
    public static Builder create() {
        return new Builder();
    }

    public static ClientState state(final ClientCollections ctx, final PgPool client) {
        return new ClientState(){

            public ClientCollections getCollections() {
                return ctx;
            }

            public ClientState.RepoBuilder repos() {
                return new PgRepoBuilder(client, ctx, DocDBFactory.sqlMapper(ctx), DocDBFactory.sqlBuilder(ctx));
            }

            public Uni<ClientInsertBuilder> insert(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.insert((Repo)repo));
            }

            public ClientInsertBuilder insert(Repo repo) {
                ImmutableClientWrapper wrapper = ImmutableClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new PgClientInsertBuilder(wrapper, DocDBFactory.sqlMapper(wrapper.getNames()), DocDBFactory.sqlBuilder(wrapper.getNames()));
            }

            public Uni<ClientQuery> query(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.query((Repo)repo));
            }

            public ClientQuery query(Repo repo) {
                ImmutableClientWrapper wrapper = ImmutableClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new PgClientQuery(wrapper, DocDBFactory.sqlMapper(wrapper.getNames()), DocDBFactory.sqlBuilder(wrapper.getNames()));
            }

            public ClientState.ClientRepoState withRepo(Repo repo) {
                final ImmutableClientWrapper wrapper = ImmutableClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new ClientState.ClientRepoState(){

                    public ClientQuery query() {
                        return new PgClientQuery(wrapper, DocDBFactory.sqlMapper(wrapper.getNames()), DocDBFactory.sqlBuilder(wrapper.getNames()));
                    }

                    public ClientInsertBuilder insert() {
                        return new PgClientInsertBuilder(wrapper, DocDBFactory.sqlMapper(wrapper.getNames()), DocDBFactory.sqlBuilder(wrapper.getNames()));
                    }
                };
            }

            public Uni<ClientState.ClientRepoState> withRepo(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.withRepo((Repo)repo));
            }
        };
    }

    public static SqlBuilder sqlBuilder(ClientCollections ctx) {
        return new DefaultSqlBuilder(ctx);
    }

    public static SqlMapper sqlMapper(ClientCollections ctx) {
        return new DefaultSqlMapper(ctx);
    }

    public static class Builder {
        private PgPool client;
        private String db = "docdb";

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder client(PgPool client) {
            this.client = client;
            return this;
        }

        public DocDB build() {
            RepoAssert.notNull((Object)this.client, () -> "client must be defined!");
            RepoAssert.notNull((Object)this.db, () -> "db must be defined!");
            ClientCollections ctx = ClientCollections.defaults((String)this.db);
            return new DocDBDefault(DocDBFactory.state(ctx, this.client));
        }
    }
}

